/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.keyset;

import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.keyset.AbstractKeysetBuilderEndedListener;
import com.blazebit.persistence.impl.keyset.KeysetLink;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.JpaProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class KeysetManager
extends AbstractKeysetBuilderEndedListener {
    private static final String KEY_SET_PARAMETER_NAME = "_keysetParameter";
    private final ResolvingQueryGenerator queryGenerator;
    private final ParameterManager parameterManager;
    private final JpaProvider jpaProvider;
    private final DbmsDialect dbmsDialect;
    private List<OrderByExpression> orderByExpressions;

    public KeysetManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, JpaProvider jpaProvider, DbmsDialect dbmsDialect) {
        this.queryGenerator = queryGenerator;
        this.parameterManager = parameterManager;
        this.jpaProvider = jpaProvider;
        this.dbmsDialect = dbmsDialect;
    }

    public boolean hasKeyset() {
        return this.getKeysetLink() != null;
    }

    public void initialize(List<OrderByExpression> orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
        KeysetLink keysetLink = this.getKeysetLink();
        keysetLink.initialize(orderByExpressions);
    }

    public void buildOptimizedKeysetPredicate(StringBuilder sb, int positionalOffset) {
        KeysetLink keysetLink = this.getKeysetLink();
        KeysetMode keysetMode = keysetLink.getKeysetMode();
        Keyset keyset = keysetLink.getKeyset();
        Serializable[] key = keyset.getTuple();
        OrderByExpression extractedNonNullableExpression = null;
        boolean hasNullableOrderBys = false;
        for (OrderByExpression orderByExpression : this.orderByExpressions) {
            if (!orderByExpression.isNullable()) continue;
            hasNullableOrderBys = true;
            break;
        }
        extractedNonNullableExpression = this.orderByExpressions.get(0);
        if (hasNullableOrderBys || !this.dbmsDialect.supportsFullRowValueComparison()) {
            boolean optimizationAllowed;
            boolean bl = optimizationAllowed = !extractedNonNullableExpression.isNullable() || keysetMode == KeysetMode.NEXT && extractedNonNullableExpression.isNullFirst() && key[0] != null || keysetMode == KeysetMode.PREVIOUS && !extractedNonNullableExpression.isNullFirst() && key[0] != null;
            if (optimizationAllowed) {
                this.applyOptimizedKeysetNotNullItem(extractedNonNullableExpression, sb, 0, key[0], keysetMode, false, positionalOffset);
                if (this.orderByExpressions.size() > 1) {
                    sb.append(" AND NOT (");
                    this.applyKeysetItem(sb, extractedNonNullableExpression.getExpression(), "=", 0, key[0], positionalOffset);
                    sb.append(" AND ");
                    this.buildOptimizedPredicate0(keysetMode, key, sb, this.orderByExpressions, positionalOffset);
                    sb.append(")");
                }
            } else {
                this.buildKeysetPredicate0(keysetMode, key, sb, this.orderByExpressions, positionalOffset);
            }
        } else {
            ArrayList<String> leftHandsideExpressions = new ArrayList<String>(this.orderByExpressions.size());
            ArrayList<String> rightHandsideExpressions = new ArrayList<String>(this.orderByExpressions.size());
            StringBuilder renderingBuffer = new StringBuilder();
            this.queryGenerator.setClauseType(ClauseType.WHERE);
            this.queryGenerator.setQueryBuffer(renderingBuffer);
            this.queryGenerator.setClauseType(null);
            for (int i = 0; i < this.orderByExpressions.size(); ++i) {
                OrderByExpression orderByExpression = this.orderByExpressions.get(i);
                renderingBuffer.setLength(0);
                this.queryGenerator.generate(orderByExpression.getExpression());
                String renderedOrderByExpr = renderingBuffer.toString();
                renderingBuffer.setLength(0);
                this.applyKeysetParameter(renderingBuffer, i, key[i], positionalOffset);
                String renderedKeysetParameter = renderingBuffer.toString();
                if (orderByExpression.isDescending() && keysetMode != KeysetMode.PREVIOUS) {
                    leftHandsideExpressions.add(renderedOrderByExpr);
                    rightHandsideExpressions.add(renderedKeysetParameter);
                    continue;
                }
                leftHandsideExpressions.add(renderedKeysetParameter);
                rightHandsideExpressions.add(renderedOrderByExpr);
            }
            this.renderRowValueComparison(sb, keysetMode == KeysetMode.SAME ? "<=" : "<", leftHandsideExpressions, rightHandsideExpressions);
        }
    }

    private void renderRowValueComparison(StringBuilder sb, String operator, Collection<String> leftHandsideExpressions, Collection<String> rightHandsideExpressions) {
        sb.append(this.jpaProvider.getCustomFunctionInvocation("compare_row_value", leftHandsideExpressions.size() + rightHandsideExpressions.size() + 1)).append('\'').append(operator).append('\'');
        this.renderArguments(sb, leftHandsideExpressions);
        this.renderArguments(sb, rightHandsideExpressions);
        sb.append(") = true");
    }

    private void renderArguments(StringBuilder sb, Iterable<String> arguments) {
        Iterator<String> expressionIterator = arguments.iterator();
        if (expressionIterator.hasNext()) {
            sb.append(',');
            sb.append(expressionIterator.next());
            while (expressionIterator.hasNext()) {
                sb.append(',').append(expressionIterator.next());
            }
        }
    }

    public void buildKeysetPredicate(StringBuilder sb, int positionalOffset) {
        KeysetLink keysetLink = this.getKeysetLink();
        KeysetMode keysetMode = keysetLink.getKeysetMode();
        Keyset keyset = keysetLink.getKeyset();
        Serializable[] key = keyset.getTuple();
        this.buildKeysetPredicate0(keysetMode, key, sb, this.orderByExpressions, positionalOffset);
    }

    private void buildOptimizedPredicate0(KeysetMode keysetMode, Serializable[] key, StringBuilder sb, List<OrderByExpression> orderByExpressions, int positionalOffset) {
        int i;
        int expressionCount = orderByExpressions.size();
        int brackets = 1;
        sb.append('(');
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        for (i = 1; i < expressionCount; ++i) {
            boolean itemRendered = true;
            boolean isNotLast = i + 1 != expressionCount;
            OrderByExpression orderByExpr = orderByExpressions.get(i);
            Expression expr = orderByExpr.getExpression();
            if (orderByExpr.isNullable()) {
                if (key[i] == null) {
                    if (keysetMode == KeysetMode.PREVIOUS == orderByExpr.isNullFirst()) {
                        this.applyKeysetNullItem(sb, expr, true);
                    } else {
                        itemRendered = false;
                    }
                } else if (keysetMode == KeysetMode.NEXT == orderByExpr.isNullFirst()) {
                    this.applyOptimizedKeysetNotNullItem(orderByExpr, sb, i, key[i], keysetMode, true, positionalOffset);
                } else {
                    this.applyKeysetNullItem(sb, expr, true);
                    sb.append(" AND ");
                    this.applyOptimizedKeysetNotNullItem(orderByExpr, sb, i, key[i], keysetMode, true, positionalOffset);
                }
            } else {
                this.applyOptimizedKeysetNotNullItem(orderByExpr, sb, i, key[i], keysetMode, true, positionalOffset);
            }
            if (!isNotLast) continue;
            if (itemRendered) {
                ++brackets;
                sb.append(" OR (");
            }
            if (key[i] == null) {
                this.applyKeysetNullItem(sb, expr, false);
            } else {
                if (orderByExpr.isNullable() && keysetMode == KeysetMode.PREVIOUS == orderByExpr.isNullFirst()) {
                    this.applyKeysetNullItem(sb, expr, true);
                    sb.append(" AND ");
                }
                this.applyKeysetItem(sb, expr, "=", i, key[i], positionalOffset);
            }
            sb.append(" AND ");
            if (i + 2 == expressionCount) continue;
            ++brackets;
            sb.append('(');
        }
        for (i = 0; i < brackets; ++i) {
            sb.append(')');
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
    }

    private void buildKeysetPredicate0(KeysetMode keysetMode, Serializable[] key, StringBuilder sb, List<OrderByExpression> orderByExpressions, int positionalOffset) {
        int i;
        int expressionCount = orderByExpressions.size();
        boolean generateEqualPredicate = true;
        int brackets = 0;
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        ++brackets;
        sb.append('(');
        for (i = 0; i < expressionCount; ++i) {
            boolean isNotLast = i + 1 != expressionCount;
            OrderByExpression orderByExpr = orderByExpressions.get(i);
            Expression expr = orderByExpr.getExpression();
            if (orderByExpr.isNullable()) {
                boolean isPrevious;
                boolean bl = isPrevious = keysetMode == KeysetMode.PREVIOUS;
                if (key[i] == null) {
                    if (orderByExpr.isNullFirst() == isPrevious) {
                        generateEqualPredicate = false;
                        this.applyKeysetNullItem(sb, expr, false);
                    } else {
                        this.applyKeysetNullItem(sb, expr, true);
                    }
                } else if (orderByExpr.isNullFirst() == isPrevious) {
                    sb.append('(');
                    this.applyKeysetNotNullableItem(orderByExpr, sb, i, key[i], keysetMode, !isNotLast, positionalOffset);
                    sb.append(" OR ");
                    this.applyKeysetNullItem(sb, expr, false);
                    sb.append(')');
                } else {
                    this.applyKeysetNotNullableItem(orderByExpr, sb, i, key[i], keysetMode, !isNotLast, positionalOffset);
                }
            } else {
                this.applyKeysetNotNullableItem(orderByExpr, sb, i, key[i], keysetMode, !isNotLast, positionalOffset);
            }
            if (!isNotLast) continue;
            if (generateEqualPredicate) {
                ++brackets;
                sb.append(" OR (");
                if (key[i] == null) {
                    this.applyKeysetNullItem(sb, expr, false);
                } else {
                    this.applyKeysetItem(sb, expr, "=", i, key[i], positionalOffset);
                }
            }
            sb.append(" AND ");
            if (i + 2 != expressionCount) {
                ++brackets;
                sb.append('(');
            }
            generateEqualPredicate = true;
        }
        for (i = 0; i < brackets; ++i) {
            sb.append(')');
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
    }

    private void applyOptimizedKeysetNotNullItem(OrderByExpression orderByExpr, StringBuilder sb, int i, Serializable keyElement, KeysetMode keysetMode, boolean negated, int positionalOffset) {
        String operator;
        switch (keysetMode) {
            case SAME: {
                if (negated) {
                    operator = orderByExpr.isAscending() ? "<" : ">";
                    break;
                }
                operator = orderByExpr.isAscending() ? ">=" : "<=";
                break;
            }
            case NEXT: {
                if (negated) {
                    if (orderByExpr.isUnique()) {
                        operator = orderByExpr.isAscending() ? "<=" : ">=";
                        break;
                    }
                    operator = orderByExpr.isAscending() ? "<" : ">";
                    break;
                }
                if (orderByExpr.isUnique()) {
                    operator = orderByExpr.isAscending() ? ">" : "<";
                    break;
                }
                operator = orderByExpr.isAscending() ? ">=" : "<=";
                break;
            }
            case PREVIOUS: {
                if (negated) {
                    if (orderByExpr.isUnique()) {
                        operator = orderByExpr.isAscending() ? ">=" : "<=";
                        break;
                    }
                    operator = orderByExpr.isAscending() ? ">" : "<";
                    break;
                }
                if (orderByExpr.isUnique()) {
                    operator = orderByExpr.isAscending() ? "<" : ">";
                    break;
                }
                operator = orderByExpr.isAscending() ? "<=" : ">=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key set mode: " + (Object)((Object)keysetMode));
            }
        }
        this.applyKeysetItem(sb, orderByExpr.getExpression(), operator, i, keyElement, positionalOffset);
    }

    private void applyKeysetNotNullableItem(OrderByExpression orderByExpr, StringBuilder sb, int i, Serializable keyElement, KeysetMode keysetMode, boolean lastOrderBy, int positionalOffset) {
        String operator;
        switch (keysetMode) {
            case SAME: {
                if (lastOrderBy) {
                    operator = orderByExpr.isAscending() ? ">=" : "<=";
                    break;
                }
                operator = orderByExpr.isAscending() ? ">" : "<";
                break;
            }
            case NEXT: {
                operator = orderByExpr.isAscending() ? ">" : "<";
                break;
            }
            case PREVIOUS: {
                operator = orderByExpr.isAscending() ? "<" : ">";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key set mode: " + (Object)((Object)keysetMode));
            }
        }
        this.applyKeysetItem(sb, orderByExpr.getExpression(), operator, i, keyElement, positionalOffset);
    }

    private void applyKeysetItem(StringBuilder sb, Expression expr, String operator, int position, Serializable keyElement, int positionalOffset) {
        this.renderOrderByExpression(sb, expr);
        sb.append(' ');
        sb.append(operator).append(' ');
        this.applyKeysetParameter(sb, position, keyElement, positionalOffset);
    }

    private void applyKeysetNullItem(StringBuilder sb, Expression expr, boolean not) {
        this.renderOrderByExpression(sb, expr);
        if (not) {
            sb.append(" IS NOT NULL");
        } else {
            sb.append(" IS NULL");
        }
    }

    private void renderOrderByExpression(StringBuilder sb, Expression expr) {
        this.queryGenerator.setClauseType(ClauseType.WHERE);
        this.queryGenerator.setQueryBuffer(sb);
        this.queryGenerator.generate(expr);
        this.queryGenerator.setClauseType(null);
    }

    private void applyKeysetParameter(StringBuilder sb, int position, Serializable keyElement, int positionalOffset) {
        if (positionalOffset > -1) {
            sb.append('?');
            String parameterName = Integer.toString(position + positionalOffset);
            sb.append(parameterName);
            this.parameterManager.addParameterMapping(parameterName, keyElement, ClauseType.WHERE);
        } else {
            sb.append(":");
            String parameterName = KEY_SET_PARAMETER_NAME + '_' + position;
            sb.append(parameterName);
            this.parameterManager.addParameterMapping(parameterName, keyElement, ClauseType.WHERE);
        }
    }
}

