/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.plan;

import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.impl.DefaultReturningResult;
import com.blazebit.persistence.impl.plan.ModificationQueryPlan;
import com.blazebit.persistence.impl.plan.SelectQueryPlan;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.ServiceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Query;

public class CustomReturningModificationQueryPlan<T>
implements ModificationQueryPlan,
SelectQueryPlan<ReturningResult<T>> {
    private final ExtendedQuerySupport extendedQuerySupport;
    private final ServiceProvider serviceProvider;
    private final DbmsDialect dbmsDialect;
    private final Query delegate;
    private final ReturningObjectBuilder<T> objectBuilder;
    private final List<Query> participatingQueries;
    private final String sql;
    private final int firstResult;
    private final int maxResults;
    private final boolean requiresWrapping;

    public CustomReturningModificationQueryPlan(ExtendedQuerySupport extendedQuerySupport, ServiceProvider serviceProvider, Query delegate, ReturningObjectBuilder<T> objectBuilder, List<Query> participatingQueries, String sql, int firstResult, int maxResults, boolean requiresWrapping) {
        this.extendedQuerySupport = extendedQuerySupport;
        this.serviceProvider = serviceProvider;
        this.dbmsDialect = (DbmsDialect)serviceProvider.getService(DbmsDialect.class);
        this.delegate = delegate;
        this.objectBuilder = objectBuilder;
        this.participatingQueries = participatingQueries;
        this.sql = sql;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.requiresWrapping = requiresWrapping;
    }

    @Override
    public int executeUpdate() {
        Query baseQuery = this.participatingQueries.get(0);
        baseQuery.setFirstResult(this.firstResult);
        baseQuery.setMaxResults(this.maxResults);
        ReturningResult result = this.extendedQuerySupport.executeReturning(this.serviceProvider, this.participatingQueries, this.delegate, this.sql);
        return result.getUpdateCount();
    }

    @Override
    public List<ReturningResult<T>> getResultList() {
        return Arrays.asList(this.getSingleResult());
    }

    @Override
    public ReturningResult<T> getSingleResult() {
        Query baseQuery = this.participatingQueries.get(0);
        baseQuery.setFirstResult(this.firstResult);
        baseQuery.setMaxResults(this.maxResults);
        ReturningResult result = this.extendedQuerySupport.executeReturning(this.serviceProvider, this.participatingQueries, this.delegate, this.sql);
        ArrayList<Object[]> resultList = result.getResultList();
        int updateCount = result.getUpdateCount();
        if (this.requiresWrapping) {
            int size = resultList.size();
            ArrayList<Object[]> newResultList = new ArrayList<Object[]>(size);
            for (int i = 0; i < size; ++i) {
                newResultList.add(new Object[]{resultList.get(i)});
            }
            resultList = newResultList;
        }
        return new DefaultReturningResult<T>((List<Object[]>)resultList, updateCount, this.dbmsDialect, this.objectBuilder);
    }
}

