/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.transform;

import com.blazebit.persistence.impl.AttributeHolder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.AggregateExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionModifierCollectingResultVisitorAdapter;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.Subquery;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class SizeTransformationVisitor
extends ExpressionModifierCollectingResultVisitorAdapter {
    private static final Set<Type.PersistenceType> IDENTIFIABLE_PERSISTENCE_TYPES = EnumSet.of(Type.PersistenceType.ENTITY, Type.PersistenceType.MAPPED_SUPERCLASS);
    private final MainQuery mainQuery;
    private final EntityMetamodel metamodel;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final JoinManager joinManager;
    private final JpaProvider jpaProvider;
    private boolean orderBySelectClause;
    private boolean distinctRequired;
    private ClauseType clause;
    private final Set<TransformedExpressionEntry> transformedExpressions = new HashSet<TransformedExpressionEntry>();
    private final Map<String, LateJoinEntry> lateJoins = new HashMap<String, LateJoinEntry>();
    private final Set<String> requiredGroupBys = new LinkedHashSet<String>();
    private final Set<String> subqueryGroupBys = new LinkedHashSet<String>();
    private JoinNode currentJoinNode;
    private Set<JoinNode> joinNodeBlacklist = new HashSet<JoinNode>();
    private boolean aggregateFunctionContext;

    public SizeTransformationVisitor(MainQuery mainQuery, SubqueryInitiatorFactory subqueryInitFactory, JoinManager joinManager, JpaProvider jpaProvider) {
        this.mainQuery = mainQuery;
        this.metamodel = mainQuery.getMetamodel();
        this.subqueryInitFactory = subqueryInitFactory;
        this.joinManager = joinManager;
        this.jpaProvider = jpaProvider;
    }

    public ClauseType getClause() {
        return this.clause;
    }

    public void setClause(ClauseType clause) {
        this.clause = clause;
    }

    public void setOrderBySelectClause(boolean orderBySelectClause) {
        this.orderBySelectClause = orderBySelectClause;
    }

    public Map<String, LateJoinEntry> getLateJoins() {
        return this.lateJoins;
    }

    public Set<String> getRequiredGroupBys() {
        return this.requiredGroupBys;
    }

    public Set<String> getSubqueryGroupBys() {
        return this.subqueryGroupBys;
    }

    private boolean isCountTransformationEnabled() {
        return this.mainQuery.getQueryConfiguration().isCountTransformationEnabled();
    }

    public Boolean visit(PathExpression expression) {
        LateJoinEntry lateJoinEntry;
        if (this.orderBySelectClause && (lateJoinEntry = this.lateJoins.get(this.getJoinLookupKey(expression))) != null) {
            lateJoinEntry.getClauseDependencies().add(ClauseType.ORDER_BY);
        }
        if (this.clause == ClauseType.SELECT) {
            for (JoinNode current = (JoinNode)expression.getBaseNode(); current != null; current = current.getParent()) {
                this.joinNodeBlacklist.add(current);
            }
        }
        return super.visit(expression);
    }

    public Boolean visit(FunctionExpression expression) {
        if (this.clause != ClauseType.WHERE && ExpressionUtils.isSizeFunction((FunctionExpression)expression)) {
            return true;
        }
        if (!this.aggregateFunctionContext && this.mainQuery.getCbf().getAggregateFunctions().contains(expression.getFunctionName().toLowerCase())) {
            this.aggregateFunctionContext = true;
            Boolean result = super.visit(expression);
            this.aggregateFunctionContext = false;
            return result;
        }
        return super.visit(expression);
    }

    protected void onModifier(ExpressionModifier parentModifier) {
        PathExpression sizeArg = (PathExpression)((FunctionExpression)parentModifier.get()).getExpressions().get(0);
        parentModifier.set(this.getSizeExpression(parentModifier, sizeArg));
        sizeArg.accept((Expression.ResultVisitor)this);
    }

    private boolean requiresBlacklistedNode(PathExpression sizeArg) {
        JoinNode sizeArgBaseNode = (JoinNode)sizeArg.getBaseNode();
        if (this.joinNodeBlacklist.contains(sizeArgBaseNode)) {
            return sizeArgBaseNode.getNodes().keySet().contains(sizeArg.getField());
        }
        return false;
    }

    private Expression getSizeExpression(ExpressionModifier parentModifier, PathExpression sizeArg) {
        Object keyExpression;
        boolean subqueryRequired;
        boolean isElementCollection;
        JoinNode sizeArgJoin = (JoinNode)sizeArg.getBaseNode();
        String property = sizeArg.getPathReference().getField();
        Type<?> nodeType = ((JoinNode)sizeArg.getBaseNode()).getBaseType();
        if (!(nodeType instanceof EntityType)) {
            throw new IllegalArgumentException("Size on a collection owned by a non-entity type is not supported yet: " + sizeArg);
        }
        EntityType startType = (EntityType)nodeType;
        AttributeHolder result = JpaUtils.getAttributeForJoining(this.metamodel, sizeArg);
        PluralAttribute targetAttribute = (PluralAttribute)result.getAttribute();
        if (targetAttribute == null) {
            throw new RuntimeException("Attribute [" + property + "] not found on class " + startType.getJavaType().getName());
        }
        PluralAttribute.CollectionType collectionType = targetAttribute.getCollectionType();
        boolean bl = isElementCollection = targetAttribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
        if (isElementCollection) {
            subqueryRequired = false;
        } else {
            ManagedType managedTargetType = (ManagedType)result.getAttributeType();
            if (managedTargetType instanceof EntityType) {
                subqueryRequired = ((EntityType)managedTargetType).getIdType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE;
            } else {
                throw new RuntimeException("Path [" + sizeArg.toString() + "] does not refer to a collection");
            }
        }
        ArrayList<PropertyExpression> pathElementExpr = new ArrayList<PropertyExpression>();
        String rootId = JpaMetamodelUtils.getIdAttribute((IdentifiableType)startType).getName();
        pathElementExpr.add(new PropertyExpression(sizeArgJoin.getAlias()));
        pathElementExpr.add(new PropertyExpression(rootId));
        PathExpression groupByExpr = new PathExpression(pathElementExpr);
        String groupByExprString = groupByExpr.toString();
        boolean bl2 = subqueryRequired = subqueryRequired || !startType.hasSingleIdAttribute() || this.joinManager.getRoots().size() > 1 || this.clause == ClauseType.JOIN || !this.isCountTransformationEnabled() || this.jpaProvider.isBag((EntityType)targetAttribute.getDeclaringType(), targetAttribute.getName()) || this.requiresBlacklistedNode(sizeArg) || this.aggregateFunctionContext;
        if (subqueryRequired) {
            return this.wrapSubqueryConditionally(this.generateSubquery(sizeArg), this.aggregateFunctionContext);
        }
        if (this.currentJoinNode != null && !this.currentJoinNode.equals(sizeArgJoin)) {
            int sizeArgJoinDepth;
            int currentJoinDepth = this.currentJoinNode.getJoinDepth();
            if (currentJoinDepth > (sizeArgJoinDepth = sizeArgJoin.getJoinDepth())) {
                return this.wrapSubqueryConditionally(this.generateSubquery(sizeArg), this.aggregateFunctionContext);
            }
            for (TransformedExpressionEntry transformedExpressionEntry : this.transformedExpressions) {
                PathExpression originalSizeArg = transformedExpressionEntry.getOriginalSizeArg();
                Expression subquery = this.wrapSubqueryConditionally(this.generateSubquery(originalSizeArg), transformedExpressionEntry.isAggregateFunctionContext());
                transformedExpressionEntry.getParentModifier().set(subquery);
            }
            this.transformedExpressions.clear();
            this.requiredGroupBys.clear();
            this.lateJoins.clear();
            this.distinctRequired = false;
            if (currentJoinDepth == sizeArgJoinDepth) {
                return this.wrapSubqueryConditionally(this.generateSubquery(sizeArg), this.aggregateFunctionContext);
            }
        }
        this.joinManager.implicitJoin((Expression)groupByExpr, true, null, null, null, false, false, false, false);
        PathExpression originalSizeArg = (PathExpression)sizeArg.clone(false);
        originalSizeArg.setPathReference(sizeArg.getPathReference());
        sizeArg.setUsedInCollectionFunction(false);
        ArrayList<Expression> countArguments = new ArrayList<Expression>();
        if (isElementCollection && collectionType != PluralAttribute.CollectionType.MAP || collectionType == PluralAttribute.CollectionType.SET) {
            if (IDENTIFIABLE_PERSISTENCE_TYPES.contains(targetAttribute.getElementType().getPersistenceType()) && targetAttribute.isCollection()) {
                PluralAttribute sizeArgTargetAttribute = (PluralAttribute)JpaMetamodelUtils.getAttribute((ManagedType)startType, (String)sizeArg.getPathReference().getField());
                SingularAttribute idAttribute = JpaMetamodelUtils.getIdAttribute((IdentifiableType)((IdentifiableType)sizeArgTargetAttribute.getElementType()));
                sizeArg.getExpressions().add(new PropertyExpression(idAttribute.getName()));
            }
            keyExpression = sizeArg;
        } else {
            sizeArg.setCollectionKeyPath(true);
            keyExpression = collectionType == PluralAttribute.CollectionType.LIST ? new ListIndexExpression(sizeArg) : new MapKeyExpression(sizeArg);
        }
        countArguments.add((Expression)keyExpression);
        AggregateExpression countExpr = this.createCountFunction(this.distinctRequired, countArguments);
        this.transformedExpressions.add(new TransformedExpressionEntry(countExpr, originalSizeArg, parentModifier, this.aggregateFunctionContext));
        String joinLookupKey = this.getJoinLookupKey(sizeArg);
        LateJoinEntry lateJoin = this.lateJoins.get(joinLookupKey);
        if (lateJoin == null) {
            lateJoin = new LateJoinEntry();
            this.lateJoins.put(joinLookupKey, lateJoin);
        }
        lateJoin.getPathsToJoin().add(sizeArg);
        lateJoin.getClauseDependencies().add(this.clause);
        this.currentJoinNode = (JoinNode)originalSizeArg.getBaseNode();
        if (!this.distinctRequired && this.lateJoins.size() + this.joinManager.getCollectionJoins().size() > 1) {
            this.distinctRequired = true;
            for (TransformedExpressionEntry transformedExpressionEntry : this.transformedExpressions) {
                AggregateExpression transformedExpr = transformedExpressionEntry.getTransformedExpression();
                if (ExpressionUtils.isCustomFunctionInvocation((FunctionExpression)transformedExpr) && "count_tuple".equalsIgnoreCase(((StringLiteral)transformedExpr.getExpressions().get(0)).getValue())) {
                    Expression possibleDistinct = (Expression)transformedExpr.getExpressions().get(1);
                    if (possibleDistinct instanceof StringLiteral && "DISTINCT".equals(((StringLiteral)possibleDistinct).getValue())) continue;
                    transformedExpr.getExpressions().add(1, new StringLiteral("DISTINCT"));
                    continue;
                }
                transformedExpr.setDistinct(true);
            }
        }
        this.requiredGroupBys.add(groupByExprString);
        return countExpr;
    }

    private String getJoinLookupKey(PathExpression pathExpression) {
        JoinNode originalNode = (JoinNode)pathExpression.getBaseNode();
        return originalNode.getAliasInfo().getAbsolutePath() + "." + pathExpression.getField();
    }

    private AggregateExpression createCountFunction(boolean distinct, List<Expression> countTupleArguments) {
        countTupleArguments.add(0, (Expression)new StringLiteral("count_tuple".toUpperCase()));
        if (distinct) {
            countTupleArguments.add(1, (Expression)new StringLiteral("DISTINCT"));
        }
        return new AggregateExpression(false, "FUNCTION", countTupleArguments);
    }

    private SubqueryExpression generateSubquery(PathExpression sizeArg) {
        JoinNode sizeArgJoin = (JoinNode)sizeArg.getBaseNode();
        Type<?> nodeType = sizeArgJoin.getNodeType();
        if (!(nodeType instanceof EntityType)) {
            throw new IllegalArgumentException("Size on a collection owned by a non-entity type is not supported yet: " + sizeArg);
        }
        EntityType startType = (EntityType)nodeType;
        Subquery countSubquery = (Subquery)this.subqueryInitFactory.createSubqueryInitiator(null, new SubqueryBuilderListenerImpl(), false).from(sizeArg.clone(true).toString()).select("COUNT(*)");
        ArrayList<PropertyExpression> pathElementExpr = new ArrayList<PropertyExpression>();
        String rootId = JpaMetamodelUtils.getIdAttribute((IdentifiableType)startType).getName();
        pathElementExpr.add(new PropertyExpression(sizeArgJoin.getAlias()));
        pathElementExpr.add(new PropertyExpression(rootId));
        PathExpression groupByExpr = new PathExpression(pathElementExpr);
        String groupByExprString = groupByExpr.toString();
        this.subqueryGroupBys.add(groupByExprString);
        return new SubqueryExpression(countSubquery);
    }

    private Expression wrapSubqueryConditionally(SubqueryExpression subquery, boolean wrap) {
        if (wrap) {
            ArrayList<Object> subqueryFunctionArguments = new ArrayList<Object>(1);
            subqueryFunctionArguments.add(new StringLiteral("subquery"));
            subqueryFunctionArguments.add(subquery);
            return new FunctionExpression("FUNCTION", subqueryFunctionArguments);
        }
        return subquery;
    }

    static class LateJoinEntry {
        private final EnumSet<ClauseType> clauseDependencies = EnumSet.noneOf(ClauseType.class);
        private final List<PathExpression> pathsToJoin = new ArrayList<PathExpression>();

        LateJoinEntry() {
        }

        public EnumSet<ClauseType> getClauseDependencies() {
            return this.clauseDependencies;
        }

        public List<PathExpression> getPathsToJoin() {
            return this.pathsToJoin;
        }
    }

    private static class TransformedExpressionEntry {
        private final AggregateExpression transformedExpression;
        private final PathExpression originalSizeArg;
        private final ExpressionModifier parentModifier;
        private final boolean aggregateFunctionContext;

        public TransformedExpressionEntry(AggregateExpression transformedExpression, PathExpression originalSizeArg, ExpressionModifier parentModifier, boolean aggregateFunctionContext) {
            this.transformedExpression = transformedExpression;
            this.originalSizeArg = originalSizeArg;
            this.parentModifier = parentModifier;
            this.aggregateFunctionContext = aggregateFunctionContext;
        }

        public AggregateExpression getTransformedExpression() {
            return this.transformedExpression;
        }

        public PathExpression getOriginalSizeArg() {
            return this.originalSizeArg;
        }

        public ExpressionModifier getParentModifier() {
            return this.parentModifier;
        }

        public boolean isAggregateFunctionContext() {
            return this.aggregateFunctionContext;
        }
    }
}

