/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.transform;

import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.OrderByManager;
import com.blazebit.persistence.impl.SelectManager;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.impl.transform.ExpressionTransformerGroup;
import com.blazebit.persistence.impl.transform.SizeExpressionTransformer;
import com.blazebit.persistence.impl.transform.SizeSelectInfoTransformer;
import com.blazebit.persistence.impl.transform.SizeTransformationVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import java.util.Set;

public class SizeTransformerGroup
implements ExpressionTransformerGroup<ExpressionModifier> {
    private final SizeTransformationVisitor sizeTransformationVisitor;
    private final SelectManager<?> selectManager;
    private final JoinManager joinManager;
    private final SizeExpressionTransformer sizeExpressionTransformer;
    private final SizeSelectInfoTransformer sizeSelectExpressionTransformer;

    public SizeTransformerGroup(SizeTransformationVisitor sizeTransformationVisitor, OrderByManager orderByManager, SelectManager<?> selectManager, JoinManager joinManager) {
        this.sizeTransformationVisitor = sizeTransformationVisitor;
        this.selectManager = selectManager;
        this.joinManager = joinManager;
        this.sizeExpressionTransformer = new SizeExpressionTransformer(sizeTransformationVisitor);
        this.sizeSelectExpressionTransformer = new SizeSelectInfoTransformer(sizeTransformationVisitor, orderByManager);
    }

    @Override
    public void applyExpressionTransformer(AbstractManager<? extends ExpressionModifier> manager) {
        if (manager.getClauseType() != ClauseType.SELECT || this.selectManager.containsSizeSelect()) {
            switch (manager.getClauseType()) {
                case WHERE: 
                case JOIN: 
                case GROUP_BY: 
                case HAVING: 
                case ORDER_BY: {
                    manager.apply(this.sizeExpressionTransformer);
                    break;
                }
                case SELECT: {
                    manager.apply(this.sizeSelectExpressionTransformer);
                    break;
                }
            }
        }
    }

    @Override
    public void afterGlobalTransformation() {
        for (SizeTransformationVisitor.LateJoinEntry lateJoinEntry : this.sizeTransformationVisitor.getLateJoins().values()) {
            PathExpression requiredJoinExpression = lateJoinEntry.getPathsToJoin().get(0);
            this.joinManager.implicitJoin((Expression)requiredJoinExpression, true, null, null, null, false, false, true, false);
            PathReference generatedJoin = requiredJoinExpression.getPathReference();
            JoinNode generatedJoinBaseNode = (JoinNode)generatedJoin.getBaseNode();
            generatedJoinBaseNode.getClauseDependencies().addAll(lateJoinEntry.getClauseDependencies());
            for (int i = 1; i < lateJoinEntry.getPathsToJoin().size(); ++i) {
                lateJoinEntry.getPathsToJoin().get(i).setPathReference((PathReference)new SimplePathReference(generatedJoinBaseNode, generatedJoin.getField(), generatedJoin.getType()));
            }
        }
    }

    @Override
    public Set<String> getRequiredGroupByClauses() {
        return this.sizeTransformationVisitor.getRequiredGroupBys();
    }

    @Override
    public Set<String> getOptionalGroupByClauses() {
        return this.sizeTransformationVisitor.getSubqueryGroupBys();
    }
}

