/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.util;

import com.blazebit.persistence.impl.util.BoyerMooreCaseInsensitiveAsciiFirstPatternFinder;
import com.blazebit.persistence.impl.util.BoyerMooreCaseInsensitiveAsciiLastPatternFinder;
import com.blazebit.persistence.impl.util.PatternFinder;
import com.blazebit.persistence.impl.util.QuoteMode;
import com.blazebit.persistence.impl.util.QuotedIdentifierAwarePatternFinder;
import java.util.ArrayList;
import java.util.List;

public class SqlUtils {
    private static final String SELECT = "select ";
    private static final String SET = " set ";
    private static final String FROM = " from ";
    private static final String WITH = "with ";
    private static final String WHERE = " where ";
    private static final String ORDER_BY = " order by ";
    private static final String AS = " as ";
    private static final String FROM_FINAL_TABLE = " from final table (";
    private static final String NEXT_VALUE_FOR = "next value for ";
    private static final PatternFinder SELECT_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("select "));
    private static final PatternFinder SET_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" set "));
    private static final PatternFinder FROM_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" from "));
    private static final PatternFinder WITH_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("with "));
    private static final PatternFinder WHERE_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" where "));
    private static final PatternFinder ORDER_BY_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" order by "));
    private static final PatternFinder AS_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiLastPatternFinder(" as "));
    private static final PatternFinder FROM_FINAL_TABLE_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" from final table ("));
    private static final PatternFinder NEXT_VALUE_FOR_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("next value for "));
    private static final SelectItemExtractor ALIAS_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractAlias(sb);
        }
    };
    private static final SelectItemExtractor EXPRESSION_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractExpression(sb);
        }
    };
    private static final SelectItemExtractor COLUMN_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractColumn(sb);
        }
    };

    private SqlUtils() {
    }

    public static String[] getSelectItemAliases(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, ALIAS_EXTRACTOR);
    }

    public static String[] getSelectItemExpressions(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, EXPRESSION_EXTRACTOR);
    }

    public static String[] getSelectItemColumns(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, COLUMN_EXTRACTOR);
    }

    public static String[] getSelectItems(CharSequence sql, int start, SelectItemExtractor extractor) {
        int selectIndex = SELECT_FINDER.indexIn(sql, start);
        int fromIndex = FROM_FINDER.indexIn(sql, selectIndex);
        if (fromIndex == -1) {
            fromIndex = sql.length();
        }
        List<String> selectItems = SqlUtils.getExpressionItems(sql, selectIndex + SELECT.length(), fromIndex, extractor);
        return selectItems.toArray(new String[selectItems.size()]);
    }

    public static List<String> getExpressionItems(CharSequence sql) {
        return SqlUtils.getExpressionItems(sql, 0, sql.length(), EXPRESSION_EXTRACTOR);
    }

    public static List<String> getExpressionItems(CharSequence sql, int i, int end, SelectItemExtractor extractor) {
        ArrayList<String> selectItems = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int parenthesis = 0;
        QuoteMode mode = QuoteMode.NONE;
        int fromIndex = end;
        while (i < end) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) == QuoteMode.NONE) {
                if (parenthesis == 0 && c == ',') {
                    selectItems.add(extractor.extract(sb, selectItems.size(), i));
                    sb.setLength(0);
                    ++i;
                    continue;
                }
                if (c == '(') {
                    end = sql.length();
                    ++parenthesis;
                } else if (c == ')') {
                    if (i < fromIndex) {
                        end = fromIndex;
                    } else {
                        end = fromIndex = FROM_FINDER.indexIn(sql, i);
                        if (fromIndex == -1) {
                            end = fromIndex = sql.length();
                        }
                    }
                    --parenthesis;
                }
            }
            sb.append(c);
            ++i;
        }
        String lastAlias = extractor.extract(sb, selectItems.size(), i);
        if (!lastAlias.isEmpty()) {
            selectItems.add(lastAlias);
        }
        return selectItems;
    }

    public static CharSequence getSetElementSequence(CharSequence sql) {
        int setIndex = SET_FINDER.indexIn(sql);
        if (setIndex == -1) {
            return null;
        }
        setIndex += SET.length();
        int whereIndex = SqlUtils.indexOfWhere(sql);
        if (whereIndex == -1) {
            whereIndex = sql.length();
        }
        return sql.subSequence(setIndex, whereIndex);
    }

    public static int indexOfSelect(CharSequence sql) {
        int selectIndex = SELECT_FINDER.indexIn(sql);
        int withIndex = WITH_FINDER.indexIn(sql, 0, selectIndex);
        if (withIndex == -1) {
            return selectIndex;
        }
        int brackets = 0;
        QuoteMode mode = QuoteMode.NONE;
        int end = selectIndex;
        for (int i = withIndex + WITH.length(); i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = sql.length();
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            end = i < selectIndex ? selectIndex : (selectIndex = SELECT_FINDER.indexIn(sql, i));
        }
        return selectIndex;
    }

    public static int indexOfWhere(CharSequence sql) {
        int whereIndex = WHERE_FINDER.indexIn(sql);
        int brackets = 0;
        QuoteMode mode = QuoteMode.NONE;
        int end = whereIndex;
        for (int i = 0; i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = sql.length();
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            end = i < whereIndex ? whereIndex : (whereIndex = WHERE_FINDER.indexIn(sql, i));
        }
        return whereIndex;
    }

    public static int indexOfOrderBy(CharSequence sql) {
        int orderByIndex = ORDER_BY_FINDER.indexIn(sql);
        int brackets = 0;
        QuoteMode mode = QuoteMode.NONE;
        int end = orderByIndex;
        for (int i = 0; i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = sql.length();
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            end = i < orderByIndex ? orderByIndex : (orderByIndex = ORDER_BY_FINDER.indexIn(sql, i));
        }
        return orderByIndex;
    }

    public static int[] indexOfFinalTableSubquery(CharSequence sql, int selectIndex) {
        int fromFinalTableIndex = FROM_FINAL_TABLE_FINDER.indexIn(sql, selectIndex);
        if (fromFinalTableIndex == -1) {
            return new int[]{0, sql.length()};
        }
        int brackets = 1;
        QuoteMode mode = QuoteMode.NONE;
        int end = sql.length();
        for (int i = fromFinalTableIndex + FROM_FINAL_TABLE.length(); i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            return new int[]{fromFinalTableIndex + FROM_FINAL_TABLE.length(), i};
        }
        return new int[]{0, sql.length()};
    }

    public static int indexOfTableName(CharSequence sql, String tableName) {
        QuotedIdentifierAwarePatternFinder finder;
        int index;
        int startIndex = FROM_FINDER.indexIn(sql, 0);
        if (startIndex == -1) {
            return -1;
        }
        startIndex += FROM.length();
        int whereIndex = SqlUtils.indexOfWhere(sql);
        if (whereIndex == -1) {
            whereIndex = sql.length();
        }
        if ((index = (finder = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" " + tableName + " "))).indexIn(sql, startIndex, whereIndex)) == -1) {
            return -1;
        }
        return index + 1;
    }

    public static String extractAlias(StringBuilder sb) {
        int aliasEndCharIndex = SqlUtils.findLastNonWhitespace(sb);
        QuoteMode mode = QuoteMode.NONE.onCharBackwards(sb.charAt(aliasEndCharIndex));
        int endIndex = aliasEndCharIndex;
        if (mode != QuoteMode.NONE) {
            while ((mode = mode.onCharBackwards(sb.charAt(--endIndex))) != QuoteMode.NONE || endIndex > 0 && sb.charAt(endIndex) == sb.charAt(endIndex - 1)) {
            }
        }
        int aliasBeforeIndex = SqlUtils.findLastWhitespace(sb, endIndex);
        int dotIndex = sb.lastIndexOf(".", endIndex);
        aliasBeforeIndex = Math.max(aliasBeforeIndex, dotIndex);
        if (NEXT_VALUE_FOR_FINDER.indexIn(sb) != -1) {
            return sb.toString();
        }
        return sb.substring(aliasBeforeIndex + 1, aliasEndCharIndex + 1);
    }

    public static String extractAlias(CharSequence sb, int index) {
        char c;
        int i;
        int aliasBeginCharIndex = SqlUtils.skipWhitespaces(sb, index);
        int asIndex = AS_FINDER.indexIn(sb, aliasBeginCharIndex - 1);
        if (asIndex != -1) {
            aliasBeginCharIndex = SqlUtils.skipWhitespaces(sb, asIndex + AS.length());
        }
        QuoteMode mode = QuoteMode.NONE;
        int end = sb.length();
        for (i = aliasBeginCharIndex; !(i >= end || (mode = mode.onChar(c = sb.charAt(i))) == QuoteMode.NONE && Character.isWhitespace(c)); ++i) {
        }
        return sb.subSequence(aliasBeginCharIndex, i).toString();
    }

    private static int skipWhitespaces(CharSequence charSequence, int index) {
        while (Character.isWhitespace(charSequence.charAt(index))) {
            int nextIndex = index + 1;
            if (nextIndex == charSequence.length()) {
                return nextIndex;
            }
            index = nextIndex;
        }
        return index;
    }

    private static String extractExpression(StringBuilder sb) {
        int asIndex = AS_FINDER.indexIn(sb);
        if (asIndex == -1) {
            return sb.toString();
        }
        return sb.substring(0, asIndex);
    }

    private static String extractColumn(StringBuilder sb) {
        int asIndex = AS_FINDER.indexIn(sb);
        if (asIndex == -1) {
            return sb.substring(SqlUtils.findLastDot(sb, sb.length()) + 1);
        }
        return sb.substring(SqlUtils.findLastDot(sb, asIndex) + 1, asIndex);
    }

    private static int findLastDot(StringBuilder sb, int end) {
        int i = end - 1;
        QuoteMode mode = QuoteMode.NONE;
        while (i >= 0) {
            char c = sb.charAt(i);
            if ((mode = mode.onCharBackwards(sb.charAt(i))) == QuoteMode.NONE) {
                if (c == '.') break;
                --i;
                continue;
            }
            --i;
        }
        return i;
    }

    private static int findLastNonWhitespace(StringBuilder sb) {
        return SqlUtils.findLastNonWhitespace(sb, sb.length() - 1);
    }

    private static int findLastNonWhitespace(StringBuilder sb, int end) {
        int i;
        for (i = end; i >= 0 && Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return i;
    }

    private static int findLastWhitespace(StringBuilder sb, int end) {
        int i;
        for (i = end; i >= 0 && !Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return i;
    }

    public static interface SelectItemExtractor {
        public String extract(StringBuilder var1, int var2, int var3);
    }
}

