/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.expression.AggregateExpression;
import com.blazebit.persistence.impl.expression.ArrayExpression;
import com.blazebit.persistence.impl.expression.CompositeExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FooExpression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.GeneralCaseExpression;
import com.blazebit.persistence.impl.expression.LiteralExpression;
import com.blazebit.persistence.impl.expression.NullExpression;
import com.blazebit.persistence.impl.expression.ParameterExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.SimpleCaseExpression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import com.blazebit.persistence.impl.expression.WhenClauseExpression;
import com.blazebit.persistence.impl.predicate.AndPredicate;
import com.blazebit.persistence.impl.predicate.BetweenPredicate;
import com.blazebit.persistence.impl.predicate.EqPredicate;
import com.blazebit.persistence.impl.predicate.ExistsPredicate;
import com.blazebit.persistence.impl.predicate.GePredicate;
import com.blazebit.persistence.impl.predicate.GtPredicate;
import com.blazebit.persistence.impl.predicate.InPredicate;
import com.blazebit.persistence.impl.predicate.IsEmptyPredicate;
import com.blazebit.persistence.impl.predicate.IsNullPredicate;
import com.blazebit.persistence.impl.predicate.LePredicate;
import com.blazebit.persistence.impl.predicate.LikePredicate;
import com.blazebit.persistence.impl.predicate.LtPredicate;
import com.blazebit.persistence.impl.predicate.MemberOfPredicate;
import com.blazebit.persistence.impl.predicate.NotPredicate;
import com.blazebit.persistence.impl.predicate.OrPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;
import com.blazebit.persistence.impl.predicate.PredicateQuantifier;
import com.blazebit.persistence.impl.predicate.QuantifiableBinaryExpressionPredicate;
import java.util.List;

public class SimpleQueryGenerator
extends VisitorAdapter {
    protected StringBuilder sb;
    private boolean conditionalContext;

    public boolean isConditionalContext() {
        return this.conditionalContext;
    }

    public boolean setConditionalContext(boolean conditionalContext) {
        boolean oldConditionalContext = this.conditionalContext;
        this.conditionalContext = conditionalContext;
        return oldConditionalContext;
    }

    public void setQueryBuffer(StringBuilder sb) {
        this.sb = sb;
    }

    protected String getBooleanConditionalExpression(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    protected String getBooleanExpression(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    @Override
    public void visit(AndPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(true);
        if (predicate.getChildren().size() == 1) {
            predicate.getChildren().get(0).accept(this);
            return;
        }
        int startLen = this.sb.length();
        String and = " AND ";
        for (Predicate child : predicate.getChildren()) {
            int len;
            if (child instanceof OrPredicate) {
                this.sb.append("(");
                len = this.sb.length();
                child.accept(this);
                if (len == this.sb.length()) {
                    this.sb.deleteCharAt(len - 1);
                    continue;
                }
                this.sb.append(")");
                this.sb.append(" AND ");
                continue;
            }
            len = this.sb.length();
            child.accept(this);
            if (len >= this.sb.length()) continue;
            this.sb.append(" AND ");
        }
        if (startLen < this.sb.length()) {
            this.sb.delete(this.sb.length() - " AND ".length(), this.sb.length());
        }
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(OrPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(true);
        if (predicate.getChildren().size() == 1) {
            predicate.getChildren().get(0).accept(this);
            return;
        }
        String or = " OR ";
        for (Predicate child : predicate.getChildren()) {
            int len;
            if (child instanceof AndPredicate) {
                this.sb.append("(");
                len = this.sb.length();
                child.accept(this);
                if (len == this.sb.length()) {
                    this.sb.deleteCharAt(len - 1);
                    continue;
                }
                this.sb.append(")");
                this.sb.append(" OR ");
                continue;
            }
            len = this.sb.length();
            child.accept(this);
            if (len >= this.sb.length()) continue;
            this.sb.append(" OR ");
        }
        if (predicate.getChildren().size() > 1) {
            this.sb.delete(this.sb.length() - " OR ".length(), this.sb.length());
        }
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(NotPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(true);
        boolean requiresParanthesis = predicate.getPredicate() instanceof AndPredicate || predicate.getPredicate() instanceof OrPredicate;
        this.sb.append("NOT ");
        if (requiresParanthesis) {
            this.sb.append("(");
            predicate.getPredicate().accept(this);
            this.sb.append(")");
        } else {
            predicate.getPredicate().accept(this);
        }
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(EqPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        if (predicate.isNegated()) {
            this.visitQuantifiableBinaryPredicate(predicate, " <> ");
        } else {
            this.visitQuantifiableBinaryPredicate(predicate, " = ");
        }
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(IsNullPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        predicate.getExpression().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" IS NOT NULL");
        } else {
            this.sb.append(" IS NULL");
        }
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(IsEmptyPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        predicate.getExpression().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" IS NOT EMPTY");
        } else {
            this.sb.append(" IS EMPTY");
        }
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(MemberOfPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        predicate.getLeft().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" NOT MEMBER OF ");
        } else {
            this.sb.append(" MEMBER OF ");
        }
        predicate.getRight().accept(this);
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(LikePredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        if (!predicate.isCaseSensitive()) {
            this.sb.append("UPPER(");
        }
        predicate.getLeft().accept(this);
        if (!predicate.isCaseSensitive()) {
            this.sb.append(")");
        }
        if (predicate.isNegated()) {
            this.sb.append(" NOT LIKE ");
        } else {
            this.sb.append(" LIKE ");
        }
        if (!predicate.isCaseSensitive()) {
            this.sb.append("UPPER(");
        }
        predicate.getRight().accept(this);
        if (!predicate.isCaseSensitive()) {
            this.sb.append(")");
        }
        if (predicate.getEscapeCharacter() != null) {
            this.sb.append(" ESCAPE ");
            if (!predicate.isCaseSensitive()) {
                this.sb.append("UPPER(");
            }
            this.sb.append("'").append(predicate.getEscapeCharacter()).append("'");
            if (!predicate.isCaseSensitive()) {
                this.sb.append(")");
            }
        }
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(BetweenPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        predicate.getLeft().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" NOT BETWEEN ");
        } else {
            this.sb.append(" BETWEEN ");
        }
        predicate.getStart().accept(this);
        this.sb.append(" AND ");
        predicate.getEnd().accept(this);
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(InPredicate predicate) {
        Object list;
        if (predicate.getRight() instanceof ParameterExpression && (list = ((ParameterExpression)predicate.getRight()).getValue()) instanceof List && ((List)list).isEmpty()) {
            if (this.conditionalContext) {
                this.sb.append(this.getBooleanConditionalExpression(false));
            } else {
                this.sb.append(this.getBooleanExpression(false));
            }
            return;
        }
        boolean oldConditionalContext = this.setConditionalContext(false);
        predicate.getLeft().accept(this);
        if (predicate.isNegated()) {
            this.sb.append(" NOT");
        }
        this.sb.append(" IN ");
        predicate.getRight().accept(this);
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(ExistsPredicate predicate) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
        }
        this.sb.append("EXISTS ");
        predicate.getExpression().accept(this);
        this.setConditionalContext(oldConditionalContext);
    }

    private void visitQuantifiableBinaryPredicate(QuantifiableBinaryExpressionPredicate predicate, String operator) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        predicate.getLeft().accept(this);
        this.sb.append(operator);
        if (predicate.getQuantifier() != PredicateQuantifier.ONE) {
            this.sb.append(predicate.getQuantifier().toString());
            this.wrapNonSubquery(predicate.getRight(), this.sb);
        } else {
            predicate.getRight().accept(this);
        }
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(GtPredicate predicate) {
        this.visitQuantifiableBinaryPredicate(predicate, " > ");
    }

    @Override
    public void visit(GePredicate predicate) {
        this.visitQuantifiableBinaryPredicate(predicate, " >= ");
    }

    @Override
    public void visit(LtPredicate predicate) {
        this.visitQuantifiableBinaryPredicate(predicate, " < ");
    }

    @Override
    public void visit(LePredicate predicate) {
        this.visitQuantifiableBinaryPredicate(predicate, " <= ");
    }

    @Override
    public void visit(ParameterExpression expression) {
        if (expression.getName() == null) {
            throw new IllegalStateException("Unsatisfied parameter " + expression.getName());
        }
        String paramName = expression.getName();
        this.sb.append(":");
        this.sb.append(paramName);
    }

    @Override
    public void visit(CompositeExpression expression) {
        for (Expression e : expression.getExpressions()) {
            e.accept(this);
        }
    }

    @Override
    public void visit(FooExpression expression) {
        this.sb.append(expression.toString());
    }

    @Override
    public void visit(LiteralExpression expression) {
        this.sb.append(expression.getLiteral());
    }

    @Override
    public void visit(NullExpression expression) {
        this.sb.append("NULL");
    }

    @Override
    public void visit(PathExpression expression) {
        this.sb.append(expression.getPath());
    }

    @Override
    public void visit(SubqueryExpression expression) {
        this.sb.append('(');
        this.sb.append(expression.getSubquery().getQueryString());
        this.sb.append(')');
    }

    @Override
    public void visit(FunctionExpression expression) {
        AggregateExpression aggregateExpression;
        boolean oldConditionalContext = this.setConditionalContext(false);
        this.sb.append(expression.getFunctionName());
        this.sb.append('(');
        if (expression instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)expression).isDistinct()) {
            this.sb.append("DISTINCT ");
        }
        if (!expression.getExpressions().isEmpty()) {
            expression.getExpressions().get(0).accept(this);
            for (int i = 1; i < expression.getExpressions().size(); ++i) {
                this.sb.append(",");
                expression.getExpressions().get(i).accept(this);
            }
        }
        this.sb.append(')');
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(GeneralCaseExpression expression) {
        this.handleCaseWhen(null, expression.getWhenClauses(), expression.getDefaultExpr());
    }

    @Override
    public void visit(SimpleCaseExpression expression) {
        this.handleCaseWhen(expression.getCaseOperand(), expression.getWhenClauses(), expression.getDefaultExpr());
    }

    @Override
    public void visit(WhenClauseExpression expression) {
        this.sb.append("WHEN ");
        boolean oldConditionalContext = this.setConditionalContext(true);
        expression.getCondition().accept(this);
        this.sb.append(" THEN ");
        this.setConditionalContext(false);
        expression.getResult().accept(this);
        this.setConditionalContext(oldConditionalContext);
    }

    private void handleCaseWhen(Expression caseOperand, List<WhenClauseExpression> whenClauses, Expression defaultExpr) {
        boolean oldConditionalContext = this.setConditionalContext(false);
        this.sb.append("CASE ");
        if (caseOperand != null) {
            caseOperand.accept(this);
            this.sb.append(" ");
        }
        for (WhenClauseExpression whenClause : whenClauses) {
            whenClause.accept(this);
            this.sb.append(" ");
        }
        this.sb.append("ELSE ");
        defaultExpr.accept(this);
        this.sb.append(" END");
        this.setConditionalContext(oldConditionalContext);
    }

    @Override
    public void visit(ArrayExpression expression) {
    }

    private void wrapNonSubquery(Expression p, StringBuilder sb) {
        boolean isNotSubquery;
        boolean bl = isNotSubquery = !(p instanceof SubqueryExpression);
        if (isNotSubquery) {
            sb.append("(");
        }
        p.accept(this);
        if (isNotSubquery) {
            sb.append(")");
        }
    }
}

