/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.expression;

import com.blazebit.persistence.impl.expression.ArrayExpression;
import com.blazebit.persistence.impl.expression.CompositeExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FooExpression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.GeneralCaseExpression;
import com.blazebit.persistence.impl.expression.LiteralExpression;
import com.blazebit.persistence.impl.expression.NullExpression;
import com.blazebit.persistence.impl.expression.ParameterExpression;
import com.blazebit.persistence.impl.expression.PathElementExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.PropertyExpression;
import com.blazebit.persistence.impl.expression.SimpleCaseExpression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.expression.WhenClauseExpression;
import com.blazebit.persistence.impl.predicate.AndPredicate;
import com.blazebit.persistence.impl.predicate.BetweenPredicate;
import com.blazebit.persistence.impl.predicate.EqPredicate;
import com.blazebit.persistence.impl.predicate.ExistsPredicate;
import com.blazebit.persistence.impl.predicate.GePredicate;
import com.blazebit.persistence.impl.predicate.GtPredicate;
import com.blazebit.persistence.impl.predicate.InPredicate;
import com.blazebit.persistence.impl.predicate.IsEmptyPredicate;
import com.blazebit.persistence.impl.predicate.IsNullPredicate;
import com.blazebit.persistence.impl.predicate.LePredicate;
import com.blazebit.persistence.impl.predicate.LikePredicate;
import com.blazebit.persistence.impl.predicate.LtPredicate;
import com.blazebit.persistence.impl.predicate.MemberOfPredicate;
import com.blazebit.persistence.impl.predicate.NotPredicate;
import com.blazebit.persistence.impl.predicate.OrPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;

public abstract class AbortableVisitorAdapter
implements Expression.ResultVisitor<Boolean> {
    @Override
    public Boolean visit(PathExpression expression) {
        for (PathElementExpression pathElementExpression : expression.getExpressions()) {
            if (!pathElementExpression.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(ArrayExpression expression) {
        if (expression.getBase().accept(this).booleanValue()) {
            return true;
        }
        return expression.getIndex().accept(this);
    }

    @Override
    public Boolean visit(PropertyExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(ParameterExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(CompositeExpression expression) {
        for (Expression expr : expression.getExpressions()) {
            if (!expr.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(FooExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(LiteralExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(NullExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(SubqueryExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(FunctionExpression expression) {
        for (Expression expression2 : expression.getExpressions()) {
            if (!expression2.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(GeneralCaseExpression expression) {
        for (WhenClauseExpression whenClause : expression.getWhenClauses()) {
            if (!whenClause.accept(this).booleanValue()) continue;
            return true;
        }
        return expression.getDefaultExpr().accept(this);
    }

    @Override
    public Boolean visit(SimpleCaseExpression expression) {
        if (expression.getCaseOperand().accept(this).booleanValue()) {
            return true;
        }
        return this.visit((GeneralCaseExpression)expression);
    }

    @Override
    public Boolean visit(WhenClauseExpression expression) {
        if (expression.getCondition().accept(this).booleanValue()) {
            return true;
        }
        return expression.getResult().accept(this);
    }

    @Override
    public Boolean visit(AndPredicate predicate) {
        for (Predicate p : predicate.getChildren()) {
            if (!p.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(OrPredicate predicate) {
        for (Predicate p : predicate.getChildren()) {
            if (!p.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(NotPredicate predicate) {
        return predicate.getPredicate().accept(this);
    }

    @Override
    public Boolean visit(EqPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(IsNullPredicate predicate) {
        return predicate.getExpression().accept(this);
    }

    @Override
    public Boolean visit(IsEmptyPredicate predicate) {
        return predicate.getExpression().accept(this);
    }

    @Override
    public Boolean visit(MemberOfPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(LikePredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(BetweenPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        if (predicate.getStart().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getEnd().accept(this);
    }

    @Override
    public Boolean visit(InPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(GtPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(GePredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(LtPredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(LePredicate predicate) {
        if (predicate.getLeft().accept(this).booleanValue()) {
            return true;
        }
        return predicate.getRight().accept(this);
    }

    @Override
    public Boolean visit(ExistsPredicate predicate) {
        return false;
    }
}

