/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.expression;

import com.blazebit.persistence.impl.expression.CompositeExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.JPQLSelectExpressionVisitorImpl;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.SyntaxErrorException;
import com.blazebit.persistence.parser.JPQLSelectExpressionLexer;
import com.blazebit.persistence.parser.JPQLSelectExpressionParser;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;

public abstract class AbstractExpressionFactory
implements ExpressionFactory {
    protected static final Logger LOG = Logger.getLogger("com.blazebit.persistence.parser");
    protected static final ANTLRErrorListener ERR_LISTENER = new ANTLRErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new SyntaxErrorException("line " + line + ":" + charPositionInLine + " " + msg);
        }

        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }
    };

    private Expression createExpression(RuleInvoker ruleInvoker, String expression) {
        return this.createExpression(ruleInvoker, expression, true);
    }

    private Expression createExpression(RuleInvoker ruleInvoker, String expression, boolean allowCaseWhen) {
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        if (expression.isEmpty()) {
            throw new IllegalArgumentException("expression");
        }
        JPQLSelectExpressionLexer l = new JPQLSelectExpressionLexer((CharStream)new ANTLRInputStream(expression));
        this.configureLexer(l);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)l);
        JPQLSelectExpressionParser p = new JPQLSelectExpressionParser((TokenStream)tokens, allowCaseWhen);
        this.configureParser(p);
        ParserRuleContext ctx = ruleInvoker.invokeRule(p);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(ctx.toStringTree());
        }
        JPQLSelectExpressionVisitorImpl visitor = new JPQLSelectExpressionVisitorImpl(tokens);
        return (Expression)visitor.visit((ParseTree)ctx);
    }

    protected abstract RuleInvoker getSimpleExpressionRuleInvoker();

    @Override
    public PathExpression createPathExpression(String expression) {
        CompositeExpression comp = (CompositeExpression)this.createExpression(new RuleInvoker(){

            @Override
            public ParserRuleContext invokeRule(JPQLSelectExpressionParser parser) {
                return parser.parsePath();
            }
        }, expression);
        return (PathExpression)comp.getExpressions().get(0);
    }

    @Override
    public Expression createOrderByExpression(String expression) {
        return this.createExpression(new RuleInvoker(){

            @Override
            public ParserRuleContext invokeRule(JPQLSelectExpressionParser parser) {
                return parser.parseOrderByClause();
            }
        }, expression, false);
    }

    @Override
    public Expression createSimpleExpression(String expression) {
        return this.createExpression(this.getSimpleExpressionRuleInvoker(), expression);
    }

    @Override
    public Expression createCaseOperandExpression(String expression) {
        return this.createExpression(new RuleInvoker(){

            @Override
            public ParserRuleContext invokeRule(JPQLSelectExpressionParser parser) {
                return parser.parseCaseOperandExpression();
            }
        }, expression);
    }

    @Override
    public Expression createScalarExpression(String expression) {
        return this.createExpression(new RuleInvoker(){

            @Override
            public ParserRuleContext invokeRule(JPQLSelectExpressionParser parser) {
                return parser.parseScalarExpression();
            }
        }, expression, false);
    }

    @Override
    public Expression createArithmeticExpression(String expression) {
        return this.createExpression(new RuleInvoker(){

            @Override
            public ParserRuleContext invokeRule(JPQLSelectExpressionParser parser) {
                return parser.parseArithmeticExpression();
            }
        }, expression, false);
    }

    @Override
    public Expression createStringExpression(String expression) {
        return this.createExpression(new RuleInvoker(){

            @Override
            public ParserRuleContext invokeRule(JPQLSelectExpressionParser parser) {
                return parser.parseStringExpression();
            }
        }, expression, false);
    }

    protected void configureLexer(JPQLSelectExpressionLexer lexer) {
        lexer.removeErrorListeners();
        lexer.addErrorListener(ERR_LISTENER);
    }

    protected void configureParser(JPQLSelectExpressionParser parser) {
        parser.removeErrorListeners();
        parser.addErrorListener(ERR_LISTENER);
    }

    protected static interface RuleInvoker {
        public ParserRuleContext invokeRule(JPQLSelectExpressionParser var1);
    }
}

