/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.expression;

import com.blazebit.persistence.impl.expression.AbstractExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FooExpression;
import java.util.ArrayList;
import java.util.List;

public class CompositeExpression
extends AbstractExpression {
    private final List<Expression> expressions;

    public CompositeExpression(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public CompositeExpression clone() {
        int size = this.expressions.size();
        ArrayList<Expression> newExpressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            newExpressions.add(this.expressions.get(i).clone());
        }
        return new CompositeExpression(newExpressions);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void append(Expression expr) {
        Expression lastExpr;
        if (expr instanceof CompositeExpression) {
            CompositeExpression composite = (CompositeExpression)expr;
            for (Expression subexpr : composite.getExpressions()) {
                this.append(subexpr);
            }
        } else if (!this.expressions.isEmpty() && expr instanceof FooExpression && (lastExpr = this.expressions.get(this.expressions.size() - 1)) instanceof FooExpression) {
            ((FooExpression)lastExpr).getStringBuilder().append((CharSequence)((FooExpression)expr).getStringBuilder());
        } else {
            this.expressions.add(expr);
        }
    }

    public void prepend(String str) {
        if (!str.isEmpty()) {
            Expression lastExpr;
            if (!this.expressions.isEmpty() && (lastExpr = this.expressions.get(this.expressions.size() - 1)) instanceof FooExpression) {
                ((FooExpression)lastExpr).getStringBuilder().insert(0, str);
            } else {
                this.expressions.add(0, new FooExpression(str));
            }
        }
    }

    public void append(String str) {
        if (str != null && !str.isEmpty()) {
            Expression lastExpr;
            if (!this.expressions.isEmpty() && (lastExpr = this.expressions.get(this.expressions.size() - 1)) instanceof FooExpression) {
                ((FooExpression)lastExpr).getStringBuilder().append(str);
            } else {
                this.expressions.add(new FooExpression(str));
            }
        }
    }

    public void append(StringBuilder sb) {
        if (sb != null && sb.length() > 0) {
            Expression lastExpr;
            if (!this.expressions.isEmpty() && (lastExpr = this.expressions.get(this.expressions.size() - 1)) instanceof FooExpression) {
                ((FooExpression)lastExpr).getStringBuilder().append((CharSequence)sb);
            } else {
                this.expressions.add(new FooExpression(sb));
            }
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.expressions != null ? this.expressions.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeExpression other = (CompositeExpression)obj;
        return this.expressions == other.expressions || this.expressions != null && this.expressions.equals(other.expressions);
    }
}

