/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.expression;

import com.blazebit.persistence.impl.expression.AbstractExpression;
import com.blazebit.persistence.impl.expression.Expression;
import java.util.ArrayList;
import java.util.List;

public class FunctionExpression
extends AbstractExpression {
    protected final String functionName;
    protected List<Expression> expressions;

    public FunctionExpression(String functionName, List<Expression> expressions) {
        this.functionName = functionName;
        this.expressions = expressions;
    }

    @Override
    public FunctionExpression clone() {
        int size = this.expressions.size();
        ArrayList<Expression> newExpressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            newExpressions.add(this.expressions.get(i).clone());
        }
        return new FunctionExpression(this.functionName, newExpressions);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<? extends Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionExpression other = (FunctionExpression)obj;
        if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
            return false;
        }
        return this.expressions == other.expressions || this.expressions != null && this.expressions.equals(other.expressions);
    }
}

