/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.expression;

import com.blazebit.persistence.impl.expression.AbstractExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.WhenClauseExpression;
import java.util.ArrayList;
import java.util.List;

public class GeneralCaseExpression
extends AbstractExpression {
    protected final List<WhenClauseExpression> whenClauses;
    protected Expression defaultExpr;

    public GeneralCaseExpression(List<WhenClauseExpression> whenClauses, Expression defaultExpr) {
        this.whenClauses = whenClauses;
        this.defaultExpr = defaultExpr;
    }

    @Override
    public GeneralCaseExpression clone() {
        int size = this.whenClauses.size();
        ArrayList<WhenClauseExpression> newWhenClauses = new ArrayList<WhenClauseExpression>(size);
        for (int i = 0; i < size; ++i) {
            newWhenClauses.add(this.whenClauses.get(i).clone());
        }
        if (this.defaultExpr == null) {
            return new GeneralCaseExpression(this.whenClauses, null);
        }
        return new GeneralCaseExpression(newWhenClauses, this.defaultExpr.clone());
    }

    public List<WhenClauseExpression> getWhenClauses() {
        return this.whenClauses;
    }

    public Expression getDefaultExpr() {
        return this.defaultExpr;
    }

    public void setDefaultExpr(Expression defaultExpr) {
        this.defaultExpr = defaultExpr;
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.whenClauses != null ? this.whenClauses.hashCode() : 0);
        hash = 47 * hash + (this.defaultExpr != null ? this.defaultExpr.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralCaseExpression other = (GeneralCaseExpression)obj;
        if (!(this.whenClauses == other.whenClauses || this.whenClauses != null && this.whenClauses.equals(other.whenClauses))) {
            return false;
        }
        return this.defaultExpr == other.defaultExpr || this.defaultExpr != null && this.defaultExpr.equals(other.defaultExpr);
    }
}

