/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.expression;

import com.blazebit.persistence.impl.expression.AbstractExpression;
import com.blazebit.persistence.impl.expression.Expression;

public class LiteralExpression
extends AbstractExpression {
    private final String wrapperFunction;
    private final String literal;

    public LiteralExpression(String wrapperFunction, String literal) {
        this.wrapperFunction = wrapperFunction;
        this.literal = literal;
    }

    @Override
    public LiteralExpression clone() {
        return new LiteralExpression(this.wrapperFunction, this.literal);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String getWrapperFunction() {
        return this.wrapperFunction;
    }

    public String getLiteral() {
        return this.literal;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.wrapperFunction);
        sb.append('(');
        sb.append(this.literal);
        sb.append(')');
        return sb.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.wrapperFunction != null ? this.wrapperFunction.hashCode() : 0);
        hash = 67 * hash + (this.literal != null ? this.literal.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiteralExpression other = (LiteralExpression)obj;
        if (this.wrapperFunction == null ? other.wrapperFunction != null : !this.wrapperFunction.equals(other.wrapperFunction)) {
            return false;
        }
        return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
    }
}

