/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.expression;

import com.blazebit.persistence.impl.expression.AbstractExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.PathElementExpression;
import java.util.ArrayList;
import java.util.List;

public class PathExpression
extends AbstractExpression
implements Expression {
    private final List<PathElementExpression> pathProperties;
    private Object baseNode;
    private String field;
    private boolean usedInCollectionFunction = false;
    private boolean collectionKeyPath;

    public PathExpression() {
        this(new ArrayList<PathElementExpression>(), false);
    }

    public PathExpression(List<PathElementExpression> pathProperties) {
        this(pathProperties, false);
    }

    public PathExpression(List<PathElementExpression> pathProperties, boolean isCollectionKeyPath) {
        this.pathProperties = pathProperties;
        this.collectionKeyPath = isCollectionKeyPath;
    }

    public PathExpression(List<PathElementExpression> pathProperties, Object baseNode, String field, boolean usedInCollectionFunction, boolean collectionKeyPath) {
        this.pathProperties = pathProperties;
        this.baseNode = baseNode;
        this.field = field;
        this.usedInCollectionFunction = usedInCollectionFunction;
        this.collectionKeyPath = collectionKeyPath;
    }

    @Override
    public Expression clone() {
        int size = this.pathProperties.size();
        ArrayList<PathElementExpression> newPathProperties = new ArrayList<PathElementExpression>(size);
        for (int i = 0; i < size; ++i) {
            newPathProperties.add(this.pathProperties.get(i).clone());
        }
        return new PathExpression(newPathProperties, this.baseNode, this.field, this.usedInCollectionFunction, this.collectionKeyPath);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public List<PathElementExpression> getExpressions() {
        return this.pathProperties;
    }

    public Object getBaseNode() {
        return this.baseNode;
    }

    public void setBaseNode(Object baseNode) {
        this.baseNode = baseNode;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public boolean isUsedInCollectionFunction() {
        return this.usedInCollectionFunction;
    }

    public void setUsedInCollectionFunction(boolean collectionValued) {
        this.usedInCollectionFunction = collectionValued;
    }

    public String getPath() {
        int size = this.pathProperties.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return this.pathProperties.get(0).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathProperties.get(0));
        for (int i = 1; i < size; ++i) {
            sb.append(".").append(this.pathProperties.get(i));
        }
        return sb.toString();
    }

    public boolean isCollectionKeyPath() {
        return this.collectionKeyPath;
    }

    public void setCollectionKeyPath(boolean collectionKeyPath) {
        this.collectionKeyPath = collectionKeyPath;
    }

    public int hashCode() {
        int hash = 3;
        if (this.baseNode != null || this.field != null) {
            hash = 31 * hash + (this.baseNode != null ? this.baseNode.hashCode() : 0);
            hash = 31 * hash + (this.field != null ? this.field.hashCode() : 0);
        } else {
            hash = 31 * hash + (this.pathProperties != null ? this.pathProperties.hashCode() : 0);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathExpression other = (PathExpression)obj;
        if (this.baseNode != null || this.field != null || other.baseNode != null || other.field != null) {
            if (!(this.baseNode == other.baseNode || this.baseNode != null && this.baseNode.equals(other.baseNode))) {
                return false;
            }
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
        } else if (!(this.pathProperties == other.pathProperties || this.pathProperties != null && this.pathProperties.equals(other.pathProperties))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getPath();
    }
}

