/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.expression;

import com.blazebit.persistence.impl.SimpleQueryGenerator;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.GeneralCaseExpression;
import com.blazebit.persistence.impl.expression.WhenClauseExpression;
import java.util.ArrayList;
import java.util.List;

public class SimpleCaseExpression
extends GeneralCaseExpression {
    private final Expression caseOperand;

    public SimpleCaseExpression(Expression caseOperand, List<WhenClauseExpression> whenClauses, Expression defaultExpr) {
        super(whenClauses, defaultExpr);
        this.caseOperand = caseOperand;
    }

    @Override
    public SimpleCaseExpression clone() {
        int size = this.whenClauses.size();
        ArrayList<WhenClauseExpression> newWhenClauses = new ArrayList<WhenClauseExpression>(size);
        for (int i = 0; i < size; ++i) {
            newWhenClauses.add(((WhenClauseExpression)this.whenClauses.get(i)).clone());
        }
        if (this.defaultExpr == null) {
            return new SimpleCaseExpression(this.caseOperand.clone(), this.whenClauses, null);
        }
        return new SimpleCaseExpression(this.caseOperand.clone(), newWhenClauses, this.defaultExpr.clone());
    }

    public Expression getCaseOperand() {
        return this.caseOperand;
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 89 * hash + (this.caseOperand != null ? this.caseOperand.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleCaseExpression other = (SimpleCaseExpression)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.caseOperand == other.caseOperand || this.caseOperand != null && this.caseOperand.equals(other.caseOperand);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        SimpleQueryGenerator generator = new SimpleQueryGenerator();
        generator.setQueryBuffer(sb);
        generator.visit(this);
        return sb.toString();
    }
}

