/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.predicate;

import com.blazebit.persistence.impl.expression.AbstractExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.predicate.Negatable;
import com.blazebit.persistence.impl.predicate.Predicate;

public class BetweenPredicate
extends AbstractExpression
implements Predicate,
Negatable {
    private Expression left;
    private Expression start;
    private Expression end;
    private boolean negated;

    public BetweenPredicate(Expression left, Expression start, Expression end) {
        this(left, start, end, false);
    }

    public BetweenPredicate(Expression left, Expression start, Expression end, boolean negated) {
        this.negated = negated;
        this.left = left;
        this.start = start;
        this.end = end;
    }

    @Override
    public BetweenPredicate clone() {
        return new BetweenPredicate(this.left.clone(), this.start.clone(), this.end.clone(), this.negated);
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getStart() {
        return this.start;
    }

    public Expression getEnd() {
        return this.end;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public void setStart(Expression start) {
        this.start = start;
    }

    public void setEnd(Expression end) {
        this.end = end;
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.left != null ? this.left.hashCode() : 0);
        hash = 61 * hash + (this.start != null ? this.start.hashCode() : 0);
        hash = 61 * hash + (this.end != null ? this.end.hashCode() : 0);
        hash = 61 * hash + (this.negated ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BetweenPredicate other = (BetweenPredicate)obj;
        if (!(this.left == other.left || this.left != null && this.left.equals(other.left))) {
            return false;
        }
        if (!(this.start == other.start || this.start != null && this.start.equals(other.start))) {
            return false;
        }
        if (!(this.end == other.end || this.end != null && this.end.equals(other.end))) {
            return false;
        }
        return this.negated == other.negated;
    }
}

