/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.predicate;

import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.predicate.Negatable;
import com.blazebit.persistence.impl.predicate.PredicateQuantifier;
import com.blazebit.persistence.impl.predicate.QuantifiableBinaryExpressionPredicate;

public class EqPredicate
extends QuantifiableBinaryExpressionPredicate
implements Negatable {
    private boolean negated;

    public EqPredicate(boolean negated) {
        this.negated = negated;
    }

    public EqPredicate(Expression left, Expression right) {
        this(left, right, PredicateQuantifier.ONE, false);
    }

    public EqPredicate(Expression left, Expression right, boolean negated) {
        super(left, right, PredicateQuantifier.ONE);
        this.negated = negated;
    }

    public EqPredicate(Expression left, Expression right, PredicateQuantifier quantifier) {
        this(left, right, quantifier, false);
    }

    public EqPredicate(Expression left, Expression right, PredicateQuantifier quantifier, boolean negated) {
        super(left, right, quantifier);
        this.negated = negated;
    }

    @Override
    public EqPredicate clone() {
        return new EqPredicate(this.left.clone(), this.right.clone(), this.quantifier, this.negated);
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + (this.negated ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        EqPredicate other = (EqPredicate)obj;
        return this.negated == other.negated;
    }
}

