/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.predicate;

import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.predicate.NegatableBinaryExpressionPredicate;

public class LikePredicate
extends NegatableBinaryExpressionPredicate {
    private final boolean caseSensitive;
    private final Character escapeCharacter;

    public LikePredicate(Expression left, Expression right, boolean caseSensitive, Character escapeCharacter) {
        super(left, right);
        this.caseSensitive = caseSensitive;
        this.escapeCharacter = escapeCharacter;
    }

    public LikePredicate(Expression left, Expression right, boolean caseSensitive, Character escapeCharacter, boolean negated) {
        super(left, right, negated);
        this.caseSensitive = caseSensitive;
        this.escapeCharacter = escapeCharacter;
    }

    @Override
    public LikePredicate clone() {
        return new LikePredicate(this.left.clone(), this.right.clone(), this.caseSensitive, this.escapeCharacter, this.negated);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.caseSensitive ? 1 : 0);
        hash = 89 * hash + (this.escapeCharacter != null ? this.escapeCharacter.hashCode() : 0);
        hash = 89 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LikePredicate other = (LikePredicate)obj;
        if (this.caseSensitive != other.caseSensitive) {
            return false;
        }
        if (!(this.escapeCharacter == other.escapeCharacter || this.escapeCharacter != null && this.escapeCharacter.equals(other.escapeCharacter))) {
            return false;
        }
        return super.equals(obj);
    }
}

