/*
 * Decompiled with CFR 0.152.
 */
package com.blitline.image.spring;

import com.blitline.image.spring.BlitlineApi;
import com.blitline.image.spring.BlitlineObjectMapperHolder;
import com.blitline.image.spring.postback.BlitlinePostbackUrlProvider;
import com.blitline.image.spring.postback.BlitlinePostbackUrlProviders;
import com.blitline.image.spring.web.BlitlinePostbackController;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
@ComponentScan(excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value={BlitlinePostbackController.class})})
@PropertySource(value={"classpath:/blitline.properties"}, ignoreResourceNotFound=true)
public class BlitlineConfiguration {
    @Autowired
    private BlitlineObjectMapperHolder objectMapperHolder;

    @Bean
    @BlitlineApi
    public RestTemplate blitlineRestTemplate() {
        MappingJackson2HttpMessageConverter blitlineConverter = new MappingJackson2HttpMessageConverter();
        blitlineConverter.setObjectMapper(this.objectMapperHolder.getMapper());
        ArrayList<MappingJackson2HttpMessageConverter> l = new ArrayList<MappingJackson2HttpMessageConverter>(1);
        l.add(blitlineConverter);
        return new RestTemplate(l);
    }

    @Conditional(value={BlitlinePostbackUrlProviders.PropertyCondition.class})
    @Configuration
    public static class BlitlinePostbackUrlConfiguration {
        @Value(value="${blitline.postbackUrl}")
        private String postbackUrl;

        @Bean
        public BlitlinePostbackUrlProvider blitlinePropertyBasedUrl() {
            return BlitlinePostbackUrlProviders.fixedUrl(this.postbackUrl);
        }
    }
}

