/*
 * Decompiled with CFR 0.152.
 */
package com.blitline.image.spring;

import com.blitline.image.BlitlineImageJob;
import com.blitline.image.BlitlinePostResults;
import com.blitline.image.spring.BlitlineApi;
import com.blitline.image.spring.postback.BlitlinePostbackUrlProvider;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class BlitlineImageService {
    @Value(value="${blitline.applicationId:no application ID set!}")
    private String applicationId;
    @Autowired(required=false)
    private BlitlinePostbackUrlProvider postbackUrlProvider;
    @Value(value="${blitline.s3sourceBucket:#{null}}")
    private String s3bucket;
    private boolean alwaysExtendedMetadata = false;
    public static final URI BLITLINE_SUBMIT_POST_URI = URI.create("http://api.blitline.com/job");
    @Autowired(required=false)
    @BlitlineApi
    private RestTemplate blitlineRest;

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public BlitlinePostbackUrlProvider getPostbackUrlProvider() {
        return this.postbackUrlProvider;
    }

    public void setPostbackUrlProvider(BlitlinePostbackUrlProvider postbackUrlProvider) {
        this.postbackUrlProvider = postbackUrlProvider;
    }

    public String getS3bucket() {
        return this.s3bucket;
    }

    public void setS3bucket(String s3bucket) {
        this.s3bucket = s3bucket;
    }

    public boolean isAlwaysExtendedMetadata() {
        return this.alwaysExtendedMetadata;
    }

    public void setAlwaysExtendedMetadata(boolean alwaysExtendedMetadata) {
        this.alwaysExtendedMetadata = alwaysExtendedMetadata;
    }

    public RestTemplate getBlitlineRest() {
        return this.blitlineRest;
    }

    public void setBlitlineRest(RestTemplate blitlineRest) {
        this.blitlineRest = blitlineRest;
    }

    public ResponseEntity<BlitlinePostResults> submitJob(BlitlineImageJob job) {
        return this.blitlineRest.postForEntity(BLITLINE_SUBMIT_POST_URI, (Object)job, BlitlinePostResults.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BlitlineImageService[applicationId=").append(this.applicationId);
        if (this.postbackUrlProvider != null) {
            sb.append(",postbackUrlProvider=").append(this.postbackUrlProvider);
        }
        if (this.s3bucket != null) {
            sb.append(",s3Bucket=").append(this.s3bucket);
        }
        sb.append(']');
        return sb.toString();
    }

    public BlitlineImageJob.Builder jobBuilder() {
        BlitlineImageJob.Builder builder = BlitlineImageJob.forApplication((String)this.applicationId);
        if (this.postbackUrlProvider != null) {
            builder.withPostback(this.postbackUrlProvider.getPostbackUrl());
        }
        if (this.alwaysExtendedMetadata) {
            builder.withExtendedMetadata();
        }
        return builder;
    }

    public BlitlineImageJob.Builder loadUrl(String src) {
        return this.jobBuilder().fromUrl(src);
    }

    public BlitlineImageJob.Builder loadUrl(URI src) {
        return this.jobBuilder().fromUrl(src);
    }

    public BlitlineImageJob.Builder loadS3Key(String key) {
        return this.jobBuilder().fromS3(this.s3bucket, key);
    }
}

