/*
 * Decompiled with CFR 0.152.
 */
package com.blitline.image.spring.postback;

import com.blitline.image.spring.postback.BlitlinePostbackUrlProvider;
import com.blitline.image.spring.web.BlitlinePostbackController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

public class BlitlinePostbackUrlProviders {
    public static final String POSTBACK_URL_PROPERTY = "blitline.postbackUrl";

    public static BlitlinePostbackUrlProvider fixedUrl(String url) {
        return new FixedUrl(url);
    }

    public static BlitlinePostbackUrlProvider bindOnPickup() {
        return new BindOnPickupUrl();
    }

    public static BlitlinePostbackUrlProvider perRequest() {
        return new PerRequestUrl();
    }

    public static class BindOnPickupUrl
    implements BlitlinePostbackUrlProvider {
        private final Log log = LogFactory.getLog(BlitlinePostbackUrlProviders.class);
        private String url;

        @Override
        public String getPostbackUrl() {
            if (this.url == null) {
                try {
                    this.url = ControllerLinkBuilder.linkTo((Object)((BlitlinePostbackController)ControllerLinkBuilder.methodOn(BlitlinePostbackController.class, (Object[])new Object[0])).handlePostback(null, null)).toString();
                    this.log.info((Object)("bound to postback URL " + this.url));
                }
                catch (IllegalStateException e) {
                    this.log.warn((Object)"tried to find postback URL outside of an HTTP request context; will retry");
                }
                catch (Exception e) {
                    this.log.error((Object)"shouldn't happen; just here because the controller throws Exception");
                }
            }
            return this.url;
        }

        public String toString() {
            return "BindOnPickupUrl[" + (this.url == null ? "unset" : this.url) + "]";
        }
    }

    public static class FixedUrl
    implements BlitlinePostbackUrlProvider {
        private final String url;

        public FixedUrl(String url) {
            this.url = url;
        }

        @Override
        public String getPostbackUrl() {
            return this.url;
        }

        public String toString() {
            return "FixedUrl[" + this.url + "]";
        }
    }

    public static class PerRequestUrl
    implements BlitlinePostbackUrlProvider {
        private final Log log = LogFactory.getLog(BlitlinePostbackUrlProviders.class);

        @Override
        public String getPostbackUrl() {
            String url = null;
            try {
                url = ControllerLinkBuilder.linkTo((Object)((BlitlinePostbackController)ControllerLinkBuilder.methodOn(BlitlinePostbackController.class, (Object[])new Object[0])).handlePostback(null, null)).toString();
                this.log.info((Object)("using postback URL " + url + " for this request"));
            }
            catch (Exception e) {
                this.log.error((Object)"couldn't find postback URL", (Throwable)e);
            }
            return url;
        }
    }

    public static class PropertyCondition
    implements ConfigurationCondition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return context.getEnvironment().containsProperty(BlitlinePostbackUrlProviders.POSTBACK_URL_PROPERTY);
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }
    }
}

