/*
 * Decompiled with CFR 0.152.
 */
package com.brandwatch.robots.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import com.brandwatch.robots.RobotsConfig;
import com.brandwatch.robots.cli.converters.CharsetConverter;
import com.brandwatch.robots.cli.converters.URIConverter;
import com.brandwatch.robots.cli.validators.AbsoluteURIValidator;
import com.brandwatch.robots.cli.validators.NonEmptyStringValidator;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class Arguments {
    @Parameter(names={"--help", "-h"}, description="Display this helpful message.", help=true)
    private boolean helpRequested = false;
    @Nonnegative
    @Parameter(names={"--maxFileSizeBytes", "-s"}, description="Download size limit. robots.txt retrieval will give up beyond this point.", validateWith=PositiveInteger.class)
    private int maxFileSizeBytes = 196608;
    @Nonnegative
    @Parameter(names={"--maxRedirectHops", "-r"}, description="Number of HTTP 3XX (redirection) responses to follow before giving up.", validateWith=PositiveInteger.class)
    private int maxRedirectHops = 5;
    @Nonnull
    @Parameter(names={"--excludedDomains", "-x"}, description="Set of domains to always consider denied. Will consider, for each domain supplied, both exact matches of and any subdomain thereof to be excluded. Values are comma separated.")
    private List<String> excludedDomains = Lists.newArrayList();
    @Nonnull
    @Parameter(names={"--defaultCharset", "--charset", "-c"}, description="Preferred character encoding for reading robots.txt. Used when server doesn't specify encoding.", converter=CharsetConverter.class)
    private Charset defaultCharset = Charsets.UTF_8;
    @Nonnull
    @Parameter(names={"--agent", "-a"}, description="User agent identifier. Sent to the host on retrieval of robots.txt, and also used for directive group matching.", validateWith=NonEmptyStringValidator.class)
    private String agent = "<unnamed-agent>";
    @Nonnull
    @Parameter(required=true, description="RESOURCES", converter=URIConverter.class, validateWith=AbsoluteURIValidator.class)
    private List<URI> resources = Lists.newArrayList();
    @Nonnegative
    @Parameter(names={"--readTimeout", "-t"}, description="Time in millis before the client times out while downloading a response payload.", validateWith=PositiveInteger.class)
    private int readTimeoutMillis = 30000;

    @Nonnegative
    public int getMaxFileSizeBytes() {
        return this.maxFileSizeBytes;
    }

    @Nonnegative
    public int getMaxRedirectHops() {
        return this.maxRedirectHops;
    }

    @Nonnull
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Nonnull
    public List<URI> getResources() {
        return this.resources;
    }

    @Nonnull
    public String getAgent() {
        return this.agent;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    @Nonnegative
    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Nonnull
    public RobotsConfig buildRobotsConfig() {
        RobotsConfig config = new RobotsConfig();
        config.setMaxFileSizeBytes(this.getMaxFileSizeBytes());
        config.setMaxRedirectHops(this.getMaxRedirectHops());
        config.setDefaultCharset(this.getDefaultCharset());
        config.setReadTimeoutMillis(this.getReadTimeoutMillis());
        config.setExcludedDomains((Set)Sets.newHashSet(this.excludedDomains));
        return config;
    }
}

