/*
 * Decompiled with CFR 0.152.
 */
package com.brandwatch.robots.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.brandwatch.robots.cli.Arguments;
import com.brandwatch.robots.cli.Command;
import com.brandwatch.robots.cli.Result;
import java.io.PrintStream;

public class Main {
    private final PrintStream out;
    private final PrintStream err;
    private String[] args;

    public Main(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public void configure(String ... args) {
        this.args = args;
    }

    public static void main(String[] args) {
        Main main = new Main(System.out, System.err);
        main.configure(args);
        main.run();
    }

    public void run() {
        Arguments arguments = new Arguments();
        JCommander commander = new JCommander((Object)arguments);
        commander.setProgramName("robots");
        try {
            commander.parse(this.args);
        }
        catch (ParameterException e) {
            this.err.println(e.getMessage());
            this.err.println("Try `--help` for more information.");
            return;
        }
        if (arguments.isHelpRequested()) {
            StringBuilder builder = new StringBuilder();
            commander.usage(builder);
            this.out.print(builder.toString());
            return;
        }
        Command command = new Command(arguments);
        for (Result result : command.getResults()) {
            this.out.printf("%s: %s%n", result.getResource().toString(), result.isAllowed() ? "allowed" : "disallowed");
        }
    }
}

