/*
 * Decompiled with CFR 0.152.
 */
package com.brandwatch.robots.cli.converters;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import com.google.common.base.Preconditions;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URIConverter
implements IStringConverter<URI> {
    public URI convert(String uriString) {
        Preconditions.checkNotNull((Object)uriString, (Object)"uriString is null");
        try {
            if (uriString.isEmpty()) {
                return new URI(uriString);
            }
            URL url = new URL(uriString);
            return new URI(url.getProtocol(), url.getUserInfo(), IDN.toASCII(url.getHost()), url.getPort(), url.getPath(), url.getQuery(), url.getRef()).normalize();
        }
        catch (MalformedURLException e) {
            throw new ParameterException("Malformed URL: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new ParameterException("Malformed URI: " + e.getMessage());
        }
    }
}

