/*
 * Decompiled with CFR 0.152.
 */
package com.brandwatch.robots.cli.validators;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.ParameterException;
import com.brandwatch.robots.cli.converters.URIConverter;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nonnull;

public class AbsoluteURIValidator
implements IParameterValidator,
IValueValidator<URI> {
    private static final URIConverter CONVERTER = new URIConverter();

    public void validate(@Nonnull String parameterName, @Nonnull String parameterValue) throws ParameterException {
        Preconditions.checkNotNull((Object)parameterName, (Object)"parameterName is null");
        Preconditions.checkNotNull((Object)parameterValue, (Object)"parameterValue is null");
        this.validate(parameterName, CONVERTER.convert(parameterValue));
    }

    public void validate(@Nonnull String parameterName, @Nonnull URI parameterValue) throws ParameterException {
        Preconditions.checkNotNull((Object)parameterName, (Object)"parameterName is null");
        Preconditions.checkNotNull((Object)parameterValue, (Object)"parameterValue is null");
        parameterValue = parameterValue.normalize();
        if (!parameterValue.isAbsolute()) {
            throw new ParameterException(MessageFormat.format("Parameter {0} contains relative URI: {1}", parameterName, parameterValue));
        }
        if (parameterValue.getHost() == null || parameterValue.getHost().isEmpty()) {
            throw new ParameterException(MessageFormat.format("Parameter {0} URI missing host: {1}", parameterName, parameterValue));
        }
    }
}

