/*
 * Decompiled with CFR 0.152.
 */
package com.buession.aop.aspectj;

import com.buession.aop.aspectj.AfterAdviceMethodInvocationAdapter;
import com.buession.aop.aspectj.AfterReturningAdviceMethodInvocationAdapter;
import com.buession.aop.aspectj.AfterThrowingAdviceMethodInvocationAdapter;
import com.buession.aop.aspectj.AroundAdviceMethodInvocationAdapter;
import com.buession.aop.aspectj.BeforeAdviceMethodInvocationAdapter;
import com.buession.aop.interceptor.AbstractAnnotationsMethodInterceptor;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAspectjAnnotationsMethodInterceptor
extends AbstractAnnotationsMethodInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void performBeforeInterception(JoinPoint joinPoint) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.performInterceptionDebug(joinPoint);
        }
        BeforeAdviceMethodInvocationAdapter mi = BeforeAdviceMethodInvocationAdapter.createFromJoinPoint(joinPoint);
        super.invoke(mi);
    }

    public void performAfterInterception(JoinPoint joinPoint) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.performInterceptionDebug(joinPoint);
        }
        AfterAdviceMethodInvocationAdapter mi = AfterAdviceMethodInvocationAdapter.createFromJoinPoint(joinPoint);
        super.invoke(mi);
    }

    public void performAfterReturningInterception(JoinPoint joinPoint) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.performInterceptionDebug(joinPoint);
        }
        AfterReturningAdviceMethodInvocationAdapter mi = AfterReturningAdviceMethodInvocationAdapter.createFromJoinPoint(joinPoint);
        super.invoke(mi);
    }

    public void performAfterThrowingInterception(JoinPoint joinPoint) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.performInterceptionDebug(joinPoint);
        }
        AfterThrowingAdviceMethodInvocationAdapter mi = AfterThrowingAdviceMethodInvocationAdapter.createFromJoinPoint(joinPoint);
        super.invoke(mi);
    }

    public void performAroundInterception(JoinPoint joinPoint) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.performInterceptionDebug(joinPoint);
        }
        AroundAdviceMethodInvocationAdapter mi = AroundAdviceMethodInvocationAdapter.createFromJoinPoint(joinPoint);
        super.invoke(mi);
    }

    protected void performInterceptionDebug(JoinPoint joinPoint) {
        StringBuilder message = new StringBuilder(255);
        message.append("Invoking a method decorated with a annotation").append(System.lineSeparator());
        message.append("\tkind       : ").append(joinPoint.getKind()).append(System.lineSeparator());
        message.append("\tjoinPoint  : ").append(joinPoint).append(System.lineSeparator());
        message.append("\tannotations: ").append(Arrays.toString(((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotations())).append(System.lineSeparator());
        message.append("\ttarget     : ").append(joinPoint.getTarget());
        this.logger.debug(message.toString());
    }
}

