/*
 * Decompiled with CFR 0.152.
 */
package com.buession.aop.interceptor;

import com.buession.aop.MethodInvocation;
import com.buession.aop.handler.AnnotationHandler;
import com.buession.aop.interceptor.AbstractMethodInterceptor;
import com.buession.aop.interceptor.AnnotationMethodInterceptor;
import com.buession.aop.resolver.AnnotationResolver;
import com.buession.aop.resolver.DefaultAnnotationResolver;
import com.buession.core.utils.Assert;
import java.lang.annotation.Annotation;
import java.util.Optional;

public abstract class AbstractAnnotationMethodInterceptor<A extends Annotation>
extends AbstractMethodInterceptor
implements AnnotationMethodInterceptor {
    private AnnotationHandler<A> handler;
    private AnnotationResolver resolver;

    public AbstractAnnotationMethodInterceptor(AnnotationHandler<A> handler) {
        this(handler, new DefaultAnnotationResolver());
    }

    public AbstractAnnotationMethodInterceptor(AnnotationHandler<A> handler, AnnotationResolver resolver) {
        Assert.isNull(handler, (String)"AnnotationHandler cloud not be null.");
        this.setHandler(handler);
        this.setResolver(Optional.of(resolver).orElse(new DefaultAnnotationResolver()));
    }

    public AnnotationHandler<A> getHandler() {
        return this.handler;
    }

    public void setHandler(AnnotationHandler<A> handler) {
        this.handler = handler;
    }

    public AnnotationResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(AnnotationResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public boolean isSupport(MethodInvocation mi) {
        return this.getAnnotation(mi) != null;
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        this.execute(mi);
        return mi.proceed();
    }

    @Override
    public void execute(MethodInvocation mi) throws Throwable {
        this.getHandler().execute(mi, this.getAnnotation(mi));
    }

    protected A getAnnotation(MethodInvocation mi) {
        return this.getResolver().getAnnotation(mi, this.getHandler().getAnnotationClass());
    }
}

