/*
 * Decompiled with CFR 0.152.
 */
package com.buession.aop.interceptor;

import com.buession.aop.interceptor.AnnotationsMethodInterceptor;
import com.buession.core.utils.Assert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractAttributeSourceAdvisor
extends StaticMethodMatcherPointcutAdvisor {
    private static final long serialVersionUID = 66199570932815709L;
    private final Class<? extends Annotation>[] annotations;

    public AbstractAttributeSourceAdvisor(AnnotationsMethodInterceptor annotationsMethodInterceptor, Class<? extends Annotation>[] annotations) {
        Assert.isNull((Object)annotationsMethodInterceptor, (String)"AnnotationsMethodInterceptor cloud not be null.");
        Assert.isNull(annotations, (String)"Annotations cloud not be null.");
        this.setAdvice((Advice)annotationsMethodInterceptor);
        this.annotations = annotations;
    }

    public boolean matches(Method method, Class<?> targetClass) {
        Method m = method;
        if (this.isAnnotationPresent(m)) {
            return true;
        }
        if (targetClass != null) {
            try {
                m = targetClass.getMethod(m.getName(), m.getParameterTypes());
                return this.isAnnotationPresent(m) || this.isAnnotationPresent(targetClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isAnnotationPresent(Class<?> targetClazz) {
        for (Class<? extends Annotation> annotationClass : this.annotations) {
            Annotation annotation = AnnotationUtils.findAnnotation(targetClazz, annotationClass);
            if (annotation == null) continue;
            return true;
        }
        return false;
    }

    private boolean isAnnotationPresent(Method method) {
        for (Class<? extends Annotation> annotationClass : this.annotations) {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationClass);
            if (annotation == null) continue;
            return true;
        }
        return false;
    }
}

