/*
 * Decompiled with CFR 0.152.
 */
package com.buession.git;

import com.buession.git.BaseUser;
import com.buession.git.GitInfoBuilder;
import com.buession.git.Info;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.Optional;

public final class Commit
implements Info {
    private ZonedDateTime time;
    private Id id;
    private Author author;
    private Committer committer;
    private User user;
    private Message message;

    public Commit() {
    }

    public Commit(ZonedDateTime time, Id id, Author author, Committer committer, User user, Message message) {
        this.time = time;
        this.id = id;
        this.author = author;
        this.committer = committer;
        this.user = user;
        this.message = message;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public void setTime(ZonedDateTime time) {
        this.time = time;
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public Committer getCommitter() {
        return this.committer;
    }

    public void setCommitter(Committer committer) {
        this.committer = committer;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public String toString() {
        GitInfoBuilder builder = GitInfoBuilder.getInstance("commit").append("time", this.time).append("id", Optional.ofNullable(this.id).orElse(new Id())).append("author", Optional.ofNullable(this.author).orElse(new Author())).append("committer", Optional.ofNullable(this.committer).orElse(new Committer())).append("user", Optional.ofNullable(this.user).orElse(new User())).append("message", Optional.ofNullable(this.message).orElse(new Message()));
        return builder.build();
    }

    public static final class Message
    implements Info {
        private String full;
        @JsonProperty(value="short")
        private String $short;

        public Message() {
        }

        public Message(String full, String $short) {
            this.full = full;
            this.$short = $short;
        }

        public String getShort() {
            return this.$short;
        }

        public void setShort(String $short) {
            this.$short = $short;
        }

        public String getFull() {
            return this.full;
        }

        public void setFull(String full) {
            this.full = full;
        }

        public String toString() {
            GitInfoBuilder builder = GitInfoBuilder.getInstance("commit.message").append("full", this.full).append("short", this.$short);
            return builder.build();
        }
    }

    public static final class Committer
    implements Info {
        private ZonedDateTime time;

        public Committer() {
        }

        public Committer(ZonedDateTime time) {
            this.time = time;
        }

        public ZonedDateTime getTime() {
            return this.time;
        }

        public void setTime(ZonedDateTime time) {
            this.time = time;
        }

        public String toString() {
            GitInfoBuilder builder = GitInfoBuilder.getInstance("commit.committer").append("time", this.time);
            return builder.build();
        }
    }

    public static final class Author
    implements Info {
        private ZonedDateTime time;

        public Author() {
        }

        public Author(ZonedDateTime time) {
            this.time = time;
        }

        public ZonedDateTime getTime() {
            return this.time;
        }

        public void setTime(ZonedDateTime time) {
            this.time = time;
        }

        public String toString() {
            GitInfoBuilder builder = GitInfoBuilder.getInstance("commit.author").append("time", this.time);
            return builder.build();
        }
    }

    public static final class User
    extends BaseUser {
        public User() {
        }

        public User(String name, String email) {
            super(name, email);
        }

        public String toString() {
            GitInfoBuilder builder = GitInfoBuilder.getInstance("commit.user").append("name", this.getName()).append("email", this.getEmail());
            return builder.build();
        }
    }

    public static final class Id
    implements Info {
        private String value;
        private String abbrev;
        private String describe;
        private String describeShort;

        public Id() {
        }

        public Id(String value, String abbrev, String describe, String describeShort) {
            this.value = value;
            this.abbrev = abbrev;
            this.describe = describe;
            this.describeShort = describeShort;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getAbbrev() {
            return this.abbrev;
        }

        public void setAbbrev(String abbrev) {
            this.abbrev = abbrev;
        }

        public String getDescribe() {
            return this.describe;
        }

        public void setDescribe(String describe) {
            this.describe = describe;
        }

        public String getDescribeShort() {
            return this.describeShort;
        }

        public void setDescribeShort(String describeShort) {
            this.describeShort = describeShort;
        }

        public String toString() {
            GitInfoBuilder builder = GitInfoBuilder.getInstance("commit.id").append(null, this.value).append("abbrev", this.abbrev).append("describe", this.describe).append("describe-short", this.describeShort);
            return builder.build();
        }
    }
}

