/*
 * Decompiled with CFR 0.152.
 */
package com.buession.git;

import com.buession.git.Build;
import com.buession.git.Closest;
import com.buession.git.Commit;
import com.buession.git.GitInfoBuilder;
import com.buession.git.Local;
import com.buession.git.Remote;
import com.buession.git.Total;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import java.util.Set;

public class Git {
    private String branch;
    private Build build;
    private Remote remote;
    private Local local;
    private Commit commit;
    private Boolean dirty;
    private Closest closest;
    private Set<String> tags;
    private Total total;

    public Git() {
    }

    public Git(String branch, Build build, Remote remote, Local local, Commit commit, boolean dirty, Closest closest, Set<String> tags, Total total) {
        this.branch = branch;
        this.build = build;
        this.remote = remote;
        this.local = local;
        this.commit = commit;
        this.dirty = dirty;
        this.closest = closest;
        this.tags = tags;
        this.total = total;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public Remote getRemote() {
        return this.remote;
    }

    public void setRemote(Remote remote) {
        this.remote = remote;
    }

    public Local getLocal() {
        return this.local;
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public Commit getCommit() {
        return this.commit;
    }

    public void setCommit(Commit commit) {
        this.commit = commit;
    }

    public Boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(Boolean dirty) {
        this.dirty = dirty;
    }

    public Closest getClosest() {
        return this.closest;
    }

    public void setClosest(Closest closest) {
        this.closest = closest;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Total getTotal() {
        return this.total;
    }

    public void setTotal(Total total) {
        this.total = total;
    }

    @JsonIgnore
    public String getCommitId() {
        return this.getCommit() != null ? this.getCommit().getId().getValue() : null;
    }

    @JsonIgnore
    public String getShortCommitId() {
        return this.getCommit() != null ? this.getCommit().getId().getAbbrev() : null;
    }

    public String toString() {
        GitInfoBuilder builder = GitInfoBuilder.getInstance().append("branch", this.branch).append("build", Optional.ofNullable(this.build).orElse(new Build())).append("remote", Optional.ofNullable(this.remote).orElse(new Remote())).append("local", Optional.ofNullable(this.local).orElse(new Local())).append("commit", Optional.ofNullable(this.commit).orElse(new Commit())).append("dirty", this.dirty).append("closest", Optional.ofNullable(this.closest).orElse(new Closest())).append("tags", this.tags).append("total", Optional.ofNullable(this.total).orElse(new Total()));
        return builder.build();
    }
}

