/*
 * Decompiled with CFR 0.152.
 */
package com.buession.git;

import com.buession.git.Info;
import java.time.ZonedDateTime;
import java.util.Set;

class GitInfoBuilder {
    private static final String PREFIX = "git";
    private final StringBuilder sb = new StringBuilder();
    private final String group;
    private int i = 0;

    private GitInfoBuilder(String group) {
        this.group = group;
    }

    public static GitInfoBuilder getInstance() {
        return GitInfoBuilder.getInstance(null);
    }

    public static GitInfoBuilder getInstance(String group) {
        return new GitInfoBuilder(group);
    }

    public GitInfoBuilder append(String name, String value) {
        this.ensure();
        this.ensurePrefix();
        if (name != null) {
            this.sb.append(name).append('=');
        } else {
            this.endDotReplaceToEqualsSign();
        }
        if (value != null) {
            this.sb.append(value);
        }
        return this;
    }

    public GitInfoBuilder append(String name, Integer value) {
        this.ensure();
        this.ensurePrefix();
        if (name != null) {
            this.sb.append(name).append('=');
        } else {
            this.endDotReplaceToEqualsSign();
        }
        this.sb.append(value == null ? "" : value.toString());
        return this;
    }

    public GitInfoBuilder append(String name, Boolean value) {
        this.ensure();
        this.ensurePrefix();
        if (name != null) {
            this.sb.append(name).append('=');
        } else {
            this.endDotReplaceToEqualsSign();
        }
        this.sb.append(value == null ? "" : value.toString());
        return this;
    }

    public GitInfoBuilder append(String name, Set<String> value) {
        if (value != null) {
            this.ensure();
            this.ensurePrefix();
            if (name != null) {
                this.sb.append(name).append('=');
            } else {
                this.endDotReplaceToEqualsSign();
            }
            if (value != null) {
                this.sb.append(String.join((CharSequence)",", value));
            }
        }
        return this;
    }

    public GitInfoBuilder append(String name, ZonedDateTime value) {
        this.ensure();
        this.ensurePrefix();
        if (name != null) {
            this.sb.append(name).append('=');
        } else {
            this.endDotReplaceToEqualsSign();
        }
        this.sb.append(value == null ? "" : value);
        return this;
    }

    public GitInfoBuilder append(String name, Info value) {
        return this.append(name, value, false);
    }

    public GitInfoBuilder append(String name, Info value, boolean containName) {
        if (value != null) {
            this.ensure();
            if (containName && name != null) {
                this.sb.append(name).append('=');
            }
            this.sb.append(value);
        }
        return this;
    }

    public String build() {
        return this.sb.toString();
    }

    private void ensurePrefix() {
        this.sb.append(PREFIX).append('.');
        if (this.group != null) {
            this.sb.append(this.group).append('.');
        }
    }

    private void ensure() {
        if (this.i++ > 0) {
            this.sb.append(System.lineSeparator());
        }
    }

    private void endDotReplaceToEqualsSign() {
        this.sb.setCharAt(this.sb.length() - 1, '=');
    }
}

