/*
 * Decompiled with CFR 0.152.
 */
package com.buession.git.parser;

import com.buession.core.utils.Assert;
import com.buession.git.Git;
import com.buession.git.parser.GitInfoParser;
import com.buession.git.parser.GitParser;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;

public abstract class AbstractGitParser
implements GitParser {
    protected Resource resource;

    public AbstractGitParser() {
    }

    public AbstractGitParser(Resource resource) {
        Assert.isNull((Object)resource, (String)"Git properties resource cloud not be null.");
        this.resource = resource;
    }

    public AbstractGitParser(String path) {
        Assert.isBlank((String)path, (String)"Git properties path cloud not be empty or null.");
        this.resource = new ClassPathResource(path);
    }

    @Override
    @Nullable
    public Git parse() {
        Properties properties = this.loadData();
        if (properties == null) {
            return null;
        }
        Git git = new Git();
        GitInfoParser infoParser = new GitInfoParser(properties);
        git.setBranch(properties.getProperty("git.branch"));
        git.setDirty(Boolean.parseBoolean(properties.getProperty("git.dirty")));
        git.setBuild(infoParser.build());
        git.setRemote(infoParser.remote());
        git.setLocal(infoParser.local());
        git.setCommit(infoParser.commit());
        git.setClosest(infoParser.closest());
        git.setTags(infoParser.tags());
        git.setTotal(infoParser.total());
        return git;
    }

    protected abstract Properties loadData();
}

