/*
 * Decompiled with CFR 0.152.
 */
package com.buession.git.parser;

import com.buession.core.collect.Arrays;
import com.buession.core.utils.StringUtils;
import com.buession.core.validator.Validate;
import com.buession.git.Build;
import com.buession.git.Closest;
import com.buession.git.Commit;
import com.buession.git.Local;
import com.buession.git.Remote;
import com.buession.git.Total;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitInfoParser {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    private final Properties properties;
    private static final Logger logger = LoggerFactory.getLogger(GitInfoParser.class);

    public GitInfoParser(Properties properties) {
        this.properties = properties;
    }

    public Build build() {
        Build build = new Build();
        build.setHost(this.getValue("build.host"));
        build.setTime(this.coercePropertyToZonedDateTime("build.time"));
        Build.User user = new Build.User(this.getValue("build.user.name"), this.getValue("build.user.email"));
        build.setUser(user);
        build.setVersion(this.getValue("build.version"));
        return build;
    }

    public Remote remote() {
        Remote remote = new Remote();
        Remote.Origin origin = new Remote.Origin(this.getValue("remote.origin.url"));
        remote.setOrigin(origin);
        return remote;
    }

    public Local local() {
        Local local = new Local();
        Local.Branch branch = new Local.Branch(this.getValue("local.branch.ahead"), this.getValue("local.branch.behind"));
        local.setBranch(branch);
        return local;
    }

    public Commit commit() {
        Commit commit = new Commit();
        commit.setTime(this.coercePropertyToZonedDateTime(this.getValue("commit.time")));
        Commit.Id id = new Commit.Id();
        id.setValue(this.getValue("commit.id"));
        id.setAbbrev(this.getValue("commit.id.abbrev"));
        id.setDescribe(this.getValue("commit.id.describe"));
        id.setDescribeShort(this.getValue("commit.id.describe-short"));
        commit.setId(id);
        Commit.User uer = new Commit.User(this.getValue("commit.user.name"), this.getValue("commit.user.email"));
        commit.setUser(uer);
        Commit.Author author = new Commit.Author(this.coercePropertyToZonedDateTime("commit.author.time"));
        commit.setAuthor(author);
        Commit.Committer committer = new Commit.Committer(this.coercePropertyToZonedDateTime("commit.committer.time"));
        commit.setCommitter(committer);
        Commit.Message message = new Commit.Message(this.getValue("commit.message.full"), this.getValue("commit.message.short"));
        commit.setMessage(message);
        return commit;
    }

    public Closest closest() {
        Closest closest = new Closest();
        Closest.Tag tag = new Closest.Tag();
        tag.setName(this.getValue("closest.tag.name"));
        Closest.Tag.Commit tagCommit = new Closest.Tag.Commit();
        String s = this.getValue("closest.tag.commit.count");
        try {
            tagCommit.setCount(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            logger.warn("git.closest.tag.commit.count value: {} cloud not convert to int.", (Object)s);
        }
        tag.setCommit(tagCommit);
        closest.setTag(tag);
        return closest;
    }

    public Set<String> tags() {
        String tags = this.getValue("tags");
        if (Validate.hasText((CharSequence)tags)) {
            return Arrays.toSet((Object[])StringUtils.split((String)tags, (char)','));
        }
        return null;
    }

    public Total total() {
        Total total = new Total();
        Total.Commit commit = new Total.Commit();
        String s = this.getValue("total.commit.count");
        try {
            commit.setCount(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            logger.warn("git.total.commit.count value: {} cloud not convert to int.", (Object)s);
        }
        total.setCommit(commit);
        return total;
    }

    private String getValue(String key) {
        return this.properties.getProperty("git." + key);
    }

    private ZonedDateTime coercePropertyToZonedDateTime(String tag) {
        String value = this.getValue(tag);
        if (Validate.hasText((CharSequence)value)) {
            Instant instant = GitInfoParser.coerceToEpoch(value);
            if (instant == null) {
                logger.warn("git.{} value: {} cloud not convert to ZonedDateTime.", (Object)tag, (Object)value);
                return null;
            }
            return instant.atZone(ZoneOffset.UTC);
        }
        return null;
    }

    private static Instant coerceToEpoch(String s) {
        try {
            return Instant.ofEpochMilli(Long.parseLong(s) * 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return DATE_TIME_FORMATTER.parse((CharSequence)s, Instant::from);
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }
    }
}

