/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.boot.application;

import com.buession.core.utils.Assert;
import com.buession.springboot.boot.application.Application;
import com.buession.springboot.boot.config.RuntimeProperties;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractApplication
implements Application {
    private Class<? extends ConfigurableApplicationContext> configurableApplicationContext;
    private Banner banner;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractApplication() {
    }

    protected AbstractApplication(Class<? extends Banner> banner) throws InstantiationException, IllegalAccessException {
        Assert.isNull(banner, (String)"Banner class cloud not be null.");
        this.banner = banner.newInstance();
    }

    protected AbstractApplication(Banner banner) {
        Assert.isNull((Object)banner, (String)"Banner cloud not be null.");
        this.banner = banner;
    }

    @Override
    public Class<? extends ConfigurableApplicationContext> getConfigurableApplicationContext() {
        return this.configurableApplicationContext;
    }

    @Override
    public void setConfigurableApplicationContext(Class<? extends ConfigurableApplicationContext> configurableApplicationContext) {
        this.configurableApplicationContext = configurableApplicationContext;
    }

    @Override
    public void startup(String[] args) {
        this.startup(this.getClass(), args);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Startup {} with arguments: {} at {}", new Object[]{this.getClass().getSimpleName(), args, new Date()});
        }
    }

    public void doStartup(Class<? extends Application> clazz, WebApplicationType webApplicationType, String[] args) {
        SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(new Class[]{clazz});
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from((Object)this.getBanner()).to(arg_0 -> ((SpringApplicationBuilder)springApplicationBuilder).banner(arg_0));
        propertyMapper.from(this.getConfigurableApplicationContext()).to(arg_0 -> ((SpringApplicationBuilder)springApplicationBuilder).contextClass(arg_0));
        springApplicationBuilder.web(webApplicationType).properties((Properties)this.createRuntimeProperties()).logStartupInfo(true).run(args);
    }

    protected Banner getBanner() {
        return this.banner;
    }

    protected RuntimeProperties createRuntimeProperties() {
        return new RuntimeProperties();
    }
}

