/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.boot.banner;

import com.buession.core.Framework;
import com.buession.core.utils.StringUtils;
import com.buession.core.utils.VersionUtils;
import com.buession.springboot.boot.utils.FileUtils;
import com.buession.springboot.boot.utils.JceUtils;
import com.github.lalyos.jfiglet.FigletFont;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Formatter;
import java.util.Properties;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.core.SpringVersion;
import org.springframework.core.env.Environment;

public abstract class AbstractBanner
implements Banner {
    private static final int SEPARATOR_REPEAT_COUNT = 60;
    private static final String LINE_SEPARATOR = String.join((CharSequence)"", Collections.nCopies(60, "-"));
    private static final String BANNER_SKIP_PROPERTY_NAME = "BANNER_SKIP";

    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        String additional = this.collectEnvironmentInfo(environment, sourceClass);
        try {
            out.println("\u001b[36m");
            out.println(FigletFont.convertOneLine((String)this.getTitle()));
            if (StringUtils.isNotBlank((CharSequence)additional)) {
                out.println(additional);
            }
            out.println("\u001b[0m");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getTitle() {
        StringBuilder sb = new StringBuilder("Buession".length());
        sb.append('(').append("Buession".toUpperCase()).append(')');
        return sb.toString();
    }

    protected String getVersion() {
        return this.getVersion(this.getClass());
    }

    protected <T> String getVersion(Class<T> clazz) {
        return clazz == null ? null : VersionUtils.determineClassVersion(clazz);
    }

    private String collectEnvironmentInfo(Environment environment, Class<?> sourceClass) {
        Properties properties = System.getProperties();
        Throwable throwable = null;
        Formatter formatter = new Formatter();
        formatter.format("%n", new Object[0]);
        formatter.format("Project Version: %s%n", this.getVersion());
        formatter.format("%s%n", LINE_SEPARATOR);
        try {
            Object runtime;
            if (!properties.containsKey(BANNER_SKIP_PROPERTY_NAME)) {
                formatter.format("Buession Framework Version: %s%n", Framework.VERSION);
                formatter.format("Buession Spring Boot Version: %s%n", this.getVersion(AbstractBanner.class));
                formatter.format("%s%n", LINE_SEPARATOR);
                formatter.format("Spring Framework Version: %s%n", SpringVersion.getVersion());
                formatter.format("Spring Boot Framework Version: %s%n", SpringBootVersion.getVersion());
                formatter.format("%s%n", LINE_SEPARATOR);
                formatter.format("OS Architecture: %s%n", properties.get("os.arch"));
                formatter.format("OS Name: %s%n", properties.get("os.name"));
                formatter.format("OS Version: %s%n", properties.get("os.version"));
                formatter.format("System Date Time: %s%n", LocalDateTime.now());
                formatter.format("System Temp Directory: %s%n", System.getProperty("java.io.tmpdir"));
                formatter.format("User Home: %s%n", System.getProperty("user.home"));
                formatter.format("%s%n", LINE_SEPARATOR);
                runtime = Runtime.getRuntime();
                formatter.format("Java Home: %s%n", properties.get("java.home"));
                formatter.format("Java Vendor: %s%n", properties.get("java.vendor"));
                formatter.format("Java Version: %s%n", properties.get("java.version"));
                formatter.format("JVM Total Memory: %s%n", FileUtils.byteCountToDisplaySize(((Runtime)runtime).totalMemory()));
                formatter.format("JVM Maximum Memory: %s%n", FileUtils.byteCountToDisplaySize(((Runtime)runtime).maxMemory()));
                formatter.format("JVM Free Memory: %s%n", FileUtils.byteCountToDisplaySize(((Runtime)runtime).freeMemory()));
                formatter.format("JCE Installed: %s%n", JceUtils.isJceInstalled() ? "Yes" : "No");
                formatter.format("%s%n", LINE_SEPARATOR);
                this.injectEnvironmentInfoIntoBanner(formatter, environment, sourceClass);
            }
            runtime = formatter.toString();
            return runtime;
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            AbstractBanner.closeFormatter(formatter, throwable);
        }
    }

    protected void injectEnvironmentInfoIntoBanner(Formatter formatter, Environment environment, Class<?> sourceClass) {
    }

    private static void closeFormatter(Formatter formatter, Throwable throwable) {
        block2: {
            try {
                formatter.close();
            }
            catch (Throwable t) {
                if (throwable == null) break block2;
                throwable.addSuppressed(t);
            }
        }
    }
}

