/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.boot.application;

import com.buession.springboot.boot.application.Application;
import com.buession.springboot.boot.config.RuntimeProperties;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractApplication
implements Application {
    private Class<? extends ConfigurableApplicationContext> configurableApplicationContext;
    private Banner banner;
    private Banner.Mode bannerMode;
    private Boolean lazyInitialization;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractApplication() {
    }

    protected AbstractApplication(Class<? extends Banner> banner) throws InstantiationException, IllegalAccessException {
        if (banner != null) {
            this.banner = banner.newInstance();
        }
    }

    protected AbstractApplication(Banner banner) {
        this.banner = banner;
    }

    @Override
    public Banner getBanner() {
        return this.banner;
    }

    @Override
    public void setBanner(Banner banner) {
        this.banner = banner;
    }

    @Override
    public Banner.Mode getBannerMode() {
        return this.bannerMode;
    }

    @Override
    public void setBannerMode(Banner.Mode bannerMode) {
        this.bannerMode = bannerMode;
    }

    @Override
    public Boolean getLazyInitialization() {
        return this.lazyInitialization;
    }

    @Override
    public void setLazyInitialization(Boolean lazyInitialization) {
        this.lazyInitialization = lazyInitialization;
    }

    @Override
    public Class<? extends ConfigurableApplicationContext> getConfigurableApplicationContext() {
        return this.configurableApplicationContext;
    }

    @Override
    public void setConfigurableApplicationContext(Class<? extends ConfigurableApplicationContext> configurableApplicationContext) {
        this.configurableApplicationContext = configurableApplicationContext;
    }

    @Override
    public void startup(String[] args) {
        this.startup(this.getClass(), args);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Startup {} with arguments: {} at {}", new Object[]{this.getClass().getSimpleName(), args, new Date()});
        }
    }

    @Override
    public void startup(Class<? extends Application> clazz, String[] args) {
        this.doStartup(clazz, args);
    }

    protected SpringApplicationBuilder springApplicationBuilder(Class<? extends Application> clazz) {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(new Class[]{clazz});
        propertyMapper.from((Object)this.getBanner()).to(arg_0 -> ((SpringApplicationBuilder)springApplicationBuilder).banner(arg_0));
        propertyMapper.from((Object)this.getBannerMode()).to(arg_0 -> ((SpringApplicationBuilder)springApplicationBuilder).bannerMode(arg_0));
        propertyMapper.from(this.getConfigurableApplicationContext()).to(arg_0 -> ((SpringApplicationBuilder)springApplicationBuilder).contextClass(arg_0));
        propertyMapper.from((Object)this.getLazyInitialization()).to(arg_0 -> ((SpringApplicationBuilder)springApplicationBuilder).lazyInitialization(arg_0));
        springApplicationBuilder.properties((Properties)this.createRuntimeProperties()).logStartupInfo(true);
        return springApplicationBuilder;
    }

    protected void doStartup(Class<? extends Application> clazz, String[] args) {
        this.springApplicationBuilder(clazz).run(args);
    }

    protected RuntimeProperties createRuntimeProperties() {
        return new RuntimeProperties();
    }
}

