/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.cache.redis.autoconfigure;

import com.buession.core.converter.mapper.PropertyMapper;
import com.buession.redis.client.connection.datasource.DataSource;
import com.buession.springboot.cache.redis.autoconfigure.DataSourceFactoryBean;
import com.buession.springboot.cache.redis.autoconfigure.RedisProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceFactoryBean<DS extends DataSource>
implements DataSourceFactoryBean<DS> {
    protected final RedisProperties properties;
    protected DS dataSource;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractDataSourceFactoryBean(RedisProperties properties) {
        this.properties = properties;
    }

    public DS getObject() throws Exception {
        return this.dataSource;
    }

    public Class<? extends DataSource> getObjectType() {
        return this.dataSource.getClass();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
            this.dataSource = this.createDataSource();
            propertyMapper.alwaysApplyingWhenHasText().from((Object)this.properties.getClientName()).to(arg_0 -> this.dataSource.setClientName(arg_0));
            propertyMapper.from((Object)this.properties.getConnectTimeout()).as(v -> (int)v.toMillis()).to(arg_0 -> this.dataSource.setConnectTimeout(arg_0));
            propertyMapper.from((Object)this.properties.getSoTimeout()).as(v -> (int)v.toMillis()).to(arg_0 -> this.dataSource.setSoTimeout(arg_0));
            propertyMapper.from((Object)this.properties.getInfiniteSoTimeout()).as(v -> (int)v.toMillis()).to(arg_0 -> this.dataSource.setInfiniteSoTimeout(arg_0));
            propertyMapper.from((Object)this.properties.getPool()).to(arg_0 -> this.dataSource.setPoolConfig(arg_0));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Initialized {} {} pool", (Object)this.dataSource.getClass().getName(), (Object)(this.dataSource.getPoolConfig() == null ? "without" : "with"));
            }
        }
    }

    protected abstract DS createDataSource();
}

