/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.cache.redis.autoconfigure;

import com.buession.core.converter.mapper.PropertyMapper;
import com.buession.core.validator.Validate;
import com.buession.redis.client.connection.datasource.jedis.JedisClusterDataSource;
import com.buession.redis.client.connection.datasource.jedis.JedisDataSource;
import com.buession.redis.client.connection.datasource.jedis.JedisRedisDataSource;
import com.buession.redis.client.connection.datasource.jedis.JedisSentinelDataSource;
import com.buession.redis.core.RedisNode;
import com.buession.redis.core.RedisURI;
import com.buession.springboot.cache.redis.autoconfigure.AbstractDataSourceFactoryBean;
import com.buession.springboot.cache.redis.autoconfigure.RedisProperties;
import com.buession.springboot.cache.redis.utils.RedisNodeUtils;
import java.text.ParseException;
import java.util.List;
import org.springframework.beans.factory.BeanInitializationException;

class JedisDataSourceFactoryBean
extends AbstractDataSourceFactoryBean<JedisRedisDataSource> {
    public JedisDataSourceFactoryBean(RedisProperties properties) {
        super(properties);
    }

    @Override
    protected JedisRedisDataSource createDataSource() {
        if (this.properties.getCluster() != null && Validate.isNotEmpty(this.properties.getCluster().getNodes())) {
            return this.createJedisClusterDataSource();
        }
        if (this.properties.getSentinel() != null && Validate.isNotEmpty(this.properties.getSentinel().getNodes())) {
            return this.createJedisSentinelDataSource();
        }
        return this.createJedisStandaloneDataSource();
    }

    private JedisRedisDataSource createJedisStandaloneDataSource() {
        JedisDataSource dataSource = new JedisDataSource();
        if (Validate.hasText((CharSequence)this.properties.getHost())) {
            dataSource.setHost(this.properties.getHost());
            dataSource.setPort(this.properties.getPort());
            dataSource.setUsername(this.properties.getUsername());
            dataSource.setPassword(this.properties.getPassword());
            dataSource.setDatabase(this.properties.getDatabase());
        } else if (Validate.hasText((CharSequence)this.properties.getUri())) {
            RedisURI redisURI = RedisURI.create((String)this.properties.getUri());
            dataSource.setHost(redisURI.getHost());
            dataSource.setPort(redisURI.getPort());
            dataSource.setUsername(redisURI.getUsername());
            dataSource.setPassword(redisURI.getPassword());
            dataSource.setDatabase(redisURI.getDatabase());
            dataSource.setClientName(redisURI.getClientName());
        } else {
            throw new BeanInitializationException("Redis host or uri cloud not be null and empty.");
        }
        return dataSource;
    }

    private JedisRedisDataSource createJedisSentinelDataSource() {
        List<RedisNode> sentinelNodes;
        RedisProperties.Sentinel sentinel = this.properties.getSentinel();
        try {
            sentinelNodes = RedisNodeUtils.parse(sentinel.getNodes(), 26379);
        }
        catch (ParseException e) {
            throw new BeanInitializationException(e.getMessage(), (Throwable)e);
        }
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        JedisSentinelDataSource dataSource = new JedisSentinelDataSource();
        propertyMapper.from(sentinel::getMasterName).to(arg_0 -> ((JedisSentinelDataSource)dataSource).setMasterName(arg_0));
        propertyMapper.from(sentinel::getConnectTimeout).as(duration -> (int)duration.toMillis()).to(arg_0 -> ((JedisSentinelDataSource)dataSource).setSentinelConnectTimeout(arg_0));
        propertyMapper.from(sentinel::getSoTimeout).as(duration -> (int)duration.toMillis()).to(arg_0 -> ((JedisSentinelDataSource)dataSource).setSentinelSoTimeout(arg_0));
        propertyMapper.from(sentinel::getClientName).to(arg_0 -> ((JedisSentinelDataSource)dataSource).setSentinelClientName(arg_0));
        dataSource.setSentinels(sentinelNodes);
        return dataSource;
    }

    private JedisRedisDataSource createJedisClusterDataSource() {
        List<RedisNode> nodes;
        RedisProperties.Cluster cluster = this.properties.getCluster();
        try {
            nodes = RedisNodeUtils.parse(cluster.getNodes(), 6379);
        }
        catch (ParseException e) {
            throw new BeanInitializationException(e.getMessage(), (Throwable)e);
        }
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        JedisClusterDataSource dataSource = new JedisClusterDataSource();
        dataSource.setNodes(nodes);
        propertyMapper.from(this.properties::getUsername).to(arg_0 -> ((JedisClusterDataSource)dataSource).setUsername(arg_0));
        propertyMapper.from(this.properties::getPassword).to(arg_0 -> ((JedisClusterDataSource)dataSource).setPassword(arg_0));
        propertyMapper.from(cluster::getMaxRedirects).to(arg_0 -> ((JedisClusterDataSource)dataSource).setMaxRedirects(arg_0));
        propertyMapper.from(cluster::getMaxTotalRetriesDuration).as(duration -> (int)duration.toMillis()).to(arg_0 -> ((JedisClusterDataSource)dataSource).setMaxTotalRetriesDuration(arg_0));
        return dataSource;
    }
}

