/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.cache.redis.autoconfigure;

import com.buession.redis.RedisTemplate;
import com.buession.redis.client.connection.datasource.DataSource;
import com.buession.redis.core.Options;
import com.buession.springboot.cache.redis.autoconfigure.RedisDataSourceConfiguration;
import com.buession.springboot.cache.redis.autoconfigure.RedisProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisProperties.class})
@ConditionalOnClass(value={RedisTemplate.class})
@Import(value={RedisDataSourceConfiguration.class})
public class RedisConfiguration {
    private final RedisProperties properties;
    private static final Logger logger = LoggerFactory.getLogger(RedisConfiguration.class);

    public RedisConfiguration(RedisProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnMissingBean
    public RedisTemplate redisTemplate(ObjectProvider<DataSource> dataSource) {
        RedisTemplate template = new RedisTemplate((DataSource)dataSource.getIfAvailable());
        Options.Builder builder = Options.Builder.getInstance().prefix(this.properties.getKeyPrefix()).serializer(this.properties.getSerializer()).enableTransactionSupport(Boolean.valueOf(this.properties.isEnableTransactionSupport()));
        template.setOptions(builder.build());
        if (logger.isTraceEnabled()) {
            logger.trace("RedisTemplate bean initialized success.");
        }
        return template;
    }
}

