/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.cache.redis.autoconfigure;

import com.buession.redis.client.connection.datasource.DataSource;
import com.buession.springboot.cache.redis.autoconfigure.JedisDataSourceFactoryBean;
import com.buession.springboot.cache.redis.autoconfigure.RedisProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedisDataSourceConfiguration {
    protected RedisProperties properties;

    public RedisDataSourceConfiguration(RedisProperties properties) {
        this.properties = properties;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={RedisProperties.class})
    @ConditionalOnClass(value={redis.clients.jedis.Jedis.class})
    @ConditionalOnMissingBean(name={"redisDataSource"}, value={DataSource.class})
    static class Jedis
    extends RedisDataSourceConfiguration {
        public Jedis(RedisProperties properties) {
            super(properties);
        }

        @Bean(name={"redisDataSource"})
        public JedisDataSourceFactoryBean dataSource() {
            return new JedisDataSourceFactoryBean(this.properties);
        }
    }
}

