/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.cache.redis.utils;

import com.buession.core.utils.StringUtils;
import com.buession.core.validator.Validate;
import com.buession.redis.core.RedisNode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RedisNodeUtils {
    public static RedisNode parse(String str, int defaultPort) throws ParseException {
        String[] hostAndPort = StringUtils.split((String)str, (char)':');
        if (hostAndPort.length == 1) {
            return new RedisNode(hostAndPort[0], defaultPort);
        }
        if (hostAndPort.length == 2) {
            try {
                int port = Integer.parseInt(hostAndPort[1]);
                if (Validate.isPort((int)port)) {
                    return new RedisNode(hostAndPort[0], port);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("Illegal redis host and port: " + str + ".", -1);
    }

    public static List<RedisNode> parse(Collection<String> str, int defaultPort) throws ParseException {
        ArrayList<RedisNode> nodes = new ArrayList<RedisNode>(str.size());
        for (String s : str) {
            nodes.add(RedisNodeUtils.parse(s, defaultPort));
        }
        return nodes;
    }
}

