/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.canal.autoconfigure;

import com.buession.canal.client.adapter.AdapterClient;
import com.buession.canal.client.adapter.KafkaAdapterClient;
import com.buession.canal.client.adapter.PulsarMQAdapterClient;
import com.buession.canal.client.adapter.RabbitMQAdapterClient;
import com.buession.canal.client.adapter.RocketMQAdapterClient;
import com.buession.canal.client.adapter.TcpAdapterClient;
import com.buession.springboot.canal.autoconfigure.AdapterClientConfiguredCondition;
import com.buession.springboot.canal.autoconfigure.AdapterProperties;
import com.buession.springboot.canal.autoconfigure.CanalProperties;
import com.buession.springboot.canal.autoconfigure.KafkaProperties;
import com.buession.springboot.canal.autoconfigure.PulsarProperties;
import com.buession.springboot.canal.autoconfigure.RabbitProperties;
import com.buession.springboot.canal.autoconfigure.RocketProperties;
import com.buession.springboot.canal.autoconfigure.TcpProperties;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CanalProperties.class})
public class AdapterClientConfiguration {

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CanalProperties.class})
    @Conditional(value={AdapterClientConfiguredCondition.TcpCanalAdapterClientConfiguredCondition.class})
    @ConditionalOnMissingBean(value={IAdapterClientConfiguration.class})
    @ConfigurationProperties(prefix="spring.canal.tcp")
    static class TcpAdapterClientConfiguration
    extends AbstractAdapterClientConfiguration {
        public TcpAdapterClientConfiguration(CanalProperties canalProperties) {
            super(canalProperties);
        }

        @Override
        @Bean
        public Set<AdapterClient> createAdapterClients() {
            TcpProperties tcp = this.canalProperties.getTcp();
            return this.createCanalAdapterClients(tcp, (destination, instance) -> new TcpAdapterClient(tcp.getServer(), tcp.getZkServers(), destination, tcp.getUsername(), tcp.getPassword(), instance));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CanalProperties.class})
    @Conditional(value={AdapterClientConfiguredCondition.RocketCanalAdapterClientConfiguredCondition.class})
    @ConditionalOnMissingBean(value={IAdapterClientConfiguration.class})
    @ConfigurationProperties(prefix="spring.canal.rocket")
    static class RocketAdapterClientConfiguration
    extends AbstractAdapterClientConfiguration {
        public RocketAdapterClientConfiguration(CanalProperties canalProperties) {
            super(canalProperties);
        }

        @Override
        @Bean
        public Set<AdapterClient> createAdapterClients() {
            RocketProperties rocket = this.canalProperties.getRocket();
            return this.createCanalAdapterClients(rocket, (topic, instance) -> new RocketMQAdapterClient(rocket.getNameServer(), topic, instance.getGroupId(), rocket.getEnableMessageTrace(), rocket.getCustomizedTraceTopic(), rocket.getAccessChannel(), instance, instance.isFlatMessage()));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CanalProperties.class})
    @Conditional(value={AdapterClientConfiguredCondition.RabbitCanalAdapterClientConfiguredCondition.class})
    @ConditionalOnMissingBean(value={IAdapterClientConfiguration.class})
    @ConfigurationProperties(prefix="spring.canal.rabbit")
    static class RabbitAdapterClientConfiguration
    extends AbstractAdapterClientConfiguration {
        public RabbitAdapterClientConfiguration(CanalProperties canalProperties) {
            super(canalProperties);
        }

        @Override
        @Bean
        public Set<AdapterClient> createAdapterClients() {
            RabbitProperties rabbit = this.canalProperties.getRabbit();
            return this.createCanalAdapterClients(rabbit, (queueName, instance) -> new RabbitMQAdapterClient(rabbit.getServer(), rabbit.getVirtualHost(), rabbit.getUsername(), rabbit.getPassword(), queueName, instance, instance.isFlatMessage()));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CanalProperties.class})
    @Conditional(value={AdapterClientConfiguredCondition.PulsarCanalAdapterClientConfiguredCondition.class})
    @ConditionalOnMissingBean(value={IAdapterClientConfiguration.class})
    @ConfigurationProperties(prefix="spring.canal.pulsar")
    static class PulsarAdapterClientConfiguration
    extends AbstractAdapterClientConfiguration {
        public PulsarAdapterClientConfiguration(CanalProperties canalProperties) {
            super(canalProperties);
        }

        @Override
        @Bean
        public Set<AdapterClient> createAdapterClients() {
            PulsarProperties pulsar = this.canalProperties.getPulsar();
            return this.createCanalAdapterClients(pulsar, (topic, instance) -> new PulsarMQAdapterClient(pulsar.getServiceUrl(), pulsar.getRoleToken(), topic, instance.getSubscriptName(), pulsar.getGetBatchTimeout(), pulsar.getBatchProcessTimeout(), pulsar.getRedeliveryDelay(), pulsar.getAckTimeout(), pulsar.isRetry(), pulsar.isRetryDLQUpperCase(), pulsar.getMaxRedeliveryCount(), instance, instance.isFlatMessage()));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CanalProperties.class})
    @Conditional(value={AdapterClientConfiguredCondition.KafkaCanalAdapterClientConfiguredCondition.class})
    @ConditionalOnMissingBean(value={IAdapterClientConfiguration.class})
    @ConfigurationProperties(prefix="spring.canal.kafka")
    static class KafkaAdapterClientConfiguration
    extends AbstractAdapterClientConfiguration {
        public KafkaAdapterClientConfiguration(CanalProperties canalProperties) {
            super(canalProperties);
        }

        @Override
        @Bean
        public Set<AdapterClient> createAdapterClients() {
            KafkaProperties kafka = this.canalProperties.getKafka();
            return this.createCanalAdapterClients(kafka, (topic, instance) -> new KafkaAdapterClient(kafka.getServers(), topic, instance.getGroupId(), instance.getPartition(), instance, instance.isFlatMessage()));
        }
    }

    static abstract class AbstractAdapterClientConfiguration
    implements IAdapterClientConfiguration {
        protected CanalProperties canalProperties;

        AbstractAdapterClientConfiguration(CanalProperties canalProperties) {
            this.canalProperties = canalProperties;
        }

        protected <IC extends com.buession.canal.core.Configuration, C extends AdapterClient> Set<AdapterClient> createCanalAdapterClients(AdapterProperties<IC> properties, CanalAdapterClientBuilder<IC, C> builder) {
            return properties.getInstances().entrySet().stream().map(e -> builder.newInstance((String)e.getKey(), (com.buession.canal.core.Configuration)e.getValue())).collect(Collectors.toSet());
        }
    }

    static interface IAdapterClientConfiguration {
        public Set<AdapterClient> createAdapterClients();
    }

    @FunctionalInterface
    static interface CanalAdapterClientBuilder<IC extends com.buession.canal.core.Configuration, C extends AdapterClient> {
        public C newInstance(String var1, IC var2);
    }
}

