/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.canal.autoconfigure;

import com.buession.canal.core.CanalMode;
import com.buession.springboot.boot.autoconfigure.condition.BaseOnPropertyExistCondition;
import com.buession.springboot.canal.autoconfigure.AbstractAdapterProperties;
import com.buession.springboot.canal.autoconfigure.AdapterProperties;
import com.buession.springboot.canal.autoconfigure.KafkaProperties;
import com.buession.springboot.canal.autoconfigure.PulsarProperties;
import com.buession.springboot.canal.autoconfigure.RabbitProperties;
import com.buession.springboot.canal.autoconfigure.RocketProperties;
import com.buession.springboot.canal.autoconfigure.TcpProperties;
import org.springframework.boot.context.properties.bind.Bindable;

interface AdapterClientConfiguredCondition {

    public static class TcpCanalAdapterClientConfiguredCondition
    extends AbstractCanalAdapterClientConfiguredCondition<TcpProperties> {
        private static final Bindable<TcpProperties> REGISTRATION = Bindable.of(TcpProperties.class);

        TcpCanalAdapterClientConfiguredCondition() {
            super(REGISTRATION, CanalMode.TCP);
        }
    }

    public static class RocketCanalAdapterClientConfiguredCondition
    extends AbstractCanalAdapterClientConfiguredCondition<RocketProperties> {
        private static final Bindable<RocketProperties> REGISTRATION = Bindable.of(RocketProperties.class);

        RocketCanalAdapterClientConfiguredCondition() {
            super(REGISTRATION, CanalMode.ROCKET_MQ);
        }
    }

    public static class PulsarCanalAdapterClientConfiguredCondition
    extends AbstractCanalAdapterClientConfiguredCondition<PulsarProperties> {
        private static final Bindable<PulsarProperties> REGISTRATION = Bindable.of(PulsarProperties.class);

        PulsarCanalAdapterClientConfiguredCondition() {
            super(REGISTRATION, CanalMode.PULSAR_MQ);
        }
    }

    public static class RabbitCanalAdapterClientConfiguredCondition
    extends AbstractCanalAdapterClientConfiguredCondition<RabbitProperties> {
        private static final Bindable<RabbitProperties> REGISTRATION = Bindable.of(RabbitProperties.class);

        RabbitCanalAdapterClientConfiguredCondition() {
            super(REGISTRATION, CanalMode.RABBIT_MQ);
        }
    }

    public static class KafkaCanalAdapterClientConfiguredCondition
    extends AbstractCanalAdapterClientConfiguredCondition<KafkaProperties> {
        private static final Bindable<KafkaProperties> REGISTRATION = Bindable.of(KafkaProperties.class);

        KafkaCanalAdapterClientConfiguredCondition() {
            super(REGISTRATION, CanalMode.KAFKA);
        }
    }

    public static abstract class AbstractCanalAdapterClientConfiguredCondition<P extends AdapterProperties<? extends AbstractAdapterProperties.BaseInstanceConfiguration>>
    extends BaseOnPropertyExistCondition<P>
    implements AdapterClientConfiguredCondition {
        public AbstractCanalAdapterClientConfiguredCondition(Bindable<P> registration, CanalMode mode) {
            super("spring.canal." + mode.getName(), "registered canal adapter clients", registration, "Canal " + mode.getName() + "adapter client configured condition");
        }
    }
}

