/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.canal.autoconfigure;

import com.buession.canal.client.CanalContext;
import com.buession.canal.client.DefaultCanalContext;
import com.buession.canal.client.adapter.AdapterClient;
import com.buession.canal.client.dispatcher.Dispatcher;
import com.buession.canal.spring.client.factory.CanalClientFactoryBean;
import com.buession.springboot.canal.autoconfigure.AdapterClientConfiguration;
import com.buession.springboot.canal.autoconfigure.CanalProperties;
import com.buession.springboot.canal.autoconfigure.ThreadPoolConfiguration;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CanalProperties.class})
@Import(value={ThreadPoolConfiguration.class, AdapterClientConfiguration.class})
public class CanalConfiguration {
    @Bean(destroyMethod="destroy")
    public CanalClientFactoryBean createCanalClientFactoryBean(ObjectProvider<Set<AdapterClient>> canalAdapterClients, ObjectProvider<Dispatcher> dispatcher, @Qualifier(value="canalExecutorService") ObjectProvider<ExecutorService> executorService) {
        CanalClientFactoryBean canalClientFactoryBean = new CanalClientFactoryBean();
        DefaultCanalContext context = new DefaultCanalContext((Set)canalAdapterClients.getIfAvailable());
        canalClientFactoryBean.setContext((CanalContext)context);
        canalClientFactoryBean.setDispatcher((Dispatcher)dispatcher.getIfAvailable());
        canalClientFactoryBean.setExecutor((ExecutorService)executorService.getIfAvailable());
        return canalClientFactoryBean;
    }
}

