/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.canal.autoconfigure;

import com.buession.canal.core.concurrent.DefaultCanalThreadPoolExecutor;
import com.buession.springboot.canal.ThreadConfig;
import com.buession.springboot.canal.autoconfigure.CanalProperties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={CanalProperties.class})
public class ThreadPoolConfiguration {
    private final ThreadConfig thread;

    public ThreadPoolConfiguration(CanalProperties canalProperties) {
        this.thread = canalProperties.getThread();
    }

    @Bean(name={"canalExecutorService"}, destroyMethod="shutdown")
    public ExecutorService executorService() {
        RejectedExecutionHandler rejectedExecutionHandler;
        switch (this.thread.getPolicy()) {
            case ABORT: {
                rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
                break;
            }
            case CALLER_RUNS: {
                rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
                break;
            }
            case DISCARD: {
                rejectedExecutionHandler = new ThreadPoolExecutor.DiscardPolicy();
                break;
            }
            case DISCARD_OLDEST: {
                rejectedExecutionHandler = new ThreadPoolExecutor.DiscardOldestPolicy();
                break;
            }
            default: {
                rejectedExecutionHandler = new ThreadPoolExecutor.DiscardPolicy();
            }
        }
        Integer corePoolSize = this.thread.getCorePoolSize();
        Integer maximumPoolSize = this.thread.getMaximumPoolSize();
        if (corePoolSize == null || maximumPoolSize == null) {
            int coreSize = Runtime.getRuntime().availableProcessors();
            if (corePoolSize == null) {
                corePoolSize = coreSize << 1;
            }
            if (maximumPoolSize == null) {
                maximumPoolSize = coreSize << 1;
            }
        }
        return new DefaultCanalThreadPoolExecutor(this.thread.getNamePrefix(), corePoolSize.intValue(), maximumPoolSize.intValue(), this.thread.getKeepAliveTime().toMillis(), rejectedExecutionHandler);
    }
}

