/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.captcha.autoconfigure;

import com.buession.security.captcha.filter.BlurRippleFilterFactory;
import com.buession.security.captcha.filter.ConfigurableFilterFactory;
import com.buession.security.captcha.filter.CurvesRippleFilterFactory;
import com.buession.security.captcha.filter.DiffuseRippleFilterFactory;
import com.buession.security.captcha.filter.DoubleRippleFilterFactory;
import com.buession.security.captcha.filter.FilterFactory;
import com.buession.security.captcha.filter.MarbleRippleFilterFactory;
import com.buession.security.captcha.filter.OvalFilterFactory;
import com.buession.security.captcha.filter.SoftenRippleFilterFactory;
import com.buession.security.captcha.filter.WobbleRippleFilterFactory;
import com.buession.security.captcha.filter.operation.CurvesImageOp;
import com.buession.security.captcha.filter.operation.OvalImageOp;
import com.buession.security.captcha.handler.DefaultHandler;
import com.buession.security.captcha.handler.Handler;
import com.buession.security.captcha.handler.generator.Generator;
import com.buession.security.captcha.servlet.CaptchaFilter;
import com.buession.springboot.captcha.autoconfigure.CaptchaProperties;
import com.buession.springboot.captcha.autoconfigure.ColorUtils;
import com.buession.springboot.captcha.autoconfigure.GeneratorUtils;
import com.buession.springboot.captcha.autoconfigure.Image;
import com.buession.springboot.captcha.autoconfigure.ImageCaptchaFactoryBuilder;
import java.awt.image.BufferedImageOp;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CaptchaProperties.class})
@ConditionalOnClass(value={Handler.class})
public class CaptchaConfiguration {
    @Autowired
    protected CaptchaProperties captchaProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="Configurable")
    public FilterFactory configurableFilterFactory() throws IllegalAccessException, InstantiationException {
        ConfigurableFilterFactory filterFactory = new ConfigurableFilterFactory();
        List<Class<? extends BufferedImageOp>> filterClass = this.captchaProperties.getImage().getFilter().getConfigurable().getFilterClass();
        if (filterClass != null) {
            ArrayList<BufferedImageOp> filters = new ArrayList<BufferedImageOp>(filterClass.size());
            for (Class<? extends BufferedImageOp> clazz : filterClass) {
                BufferedImageOp bufferedImageOp = clazz.newInstance();
                if (clazz.isAssignableFrom(CurvesImageOp.class)) {
                    CurvesImageOp curvesImageOp = (CurvesImageOp)bufferedImageOp;
                    Image.Filter.CurvesRipple curvesRipple = this.captchaProperties.getImage().getFilter().getCurvesRipple();
                    curvesImageOp.setStrokeMin(curvesRipple.getStrokeMin());
                    curvesImageOp.setStrokeMax(curvesRipple.getStrokeMax());
                    curvesImageOp.setColorFactory(ColorUtils.createColorFactory(curvesRipple.getColor()));
                } else if (clazz.isAssignableFrom(OvalImageOp.class)) {
                    OvalImageOp ovalImageOp = (OvalImageOp)bufferedImageOp;
                    Image.Filter.Oval oval = this.captchaProperties.getImage().getFilter().getOval();
                    ovalImageOp.setStrokeMin((float)oval.getStrokeMin());
                    ovalImageOp.setStrokeMax((float)oval.getStrokeMax());
                    ovalImageOp.setColorFactory(ColorUtils.createColorFactory(oval.getColor()));
                }
                filters.add(bufferedImageOp);
            }
            filterFactory.setFilters(filters);
        }
        return filterFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="DiffuseRipple")
    public FilterFactory diffuseRippleFilterFactory() {
        return new DiffuseRippleFilterFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="BlurRipple")
    public FilterFactory blurRippleFilterFactory() {
        return new BlurRippleFilterFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="DoubleRipple")
    public FilterFactory doubleRippleFilterFactory() {
        return new DoubleRippleFilterFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="MarbleRipple")
    public FilterFactory marbleRippleFilterFactory() {
        return new MarbleRippleFilterFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="SoftenRipple")
    public FilterFactory softenRippleFilterFactory() {
        return new SoftenRippleFilterFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="WobbleRipple")
    public FilterFactory wobbleRippleFilterFactory() {
        return new WobbleRippleFilterFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="CurvesRipple")
    public FilterFactory curvesRippleFilterFactory() {
        CurvesRippleFilterFactory filterFactory = new CurvesRippleFilterFactory();
        Image.Filter.CurvesRipple curvesRipple = this.captchaProperties.getImage().getFilter().getCurvesRipple();
        filterFactory.setStrokeMin(curvesRipple.getStrokeMin());
        filterFactory.setStrokeMax(curvesRipple.getStrokeMax());
        filterFactory.setColorFactory(ColorUtils.createColorFactory(curvesRipple.getColor()));
        return filterFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.captcha.image.filter", name={"mode"}, havingValue="Oval", matchIfMissing=true)
    public FilterFactory ovalFilterFactory() {
        OvalFilterFactory filterFactory = new OvalFilterFactory();
        Image.Filter.Oval oval = this.captchaProperties.getImage().getFilter().getOval();
        filterFactory.setStrokeMin((float)oval.getStrokeMin());
        filterFactory.setStrokeMax((float)oval.getStrokeMax());
        filterFactory.setColorFactory(ColorUtils.createColorFactory(oval.getColor()));
        return filterFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public Handler handler(FilterFactory filterFactory) throws InstantiationException, IllegalAccessException {
        Image image = this.captchaProperties.getImage();
        Generator generator = GeneratorUtils.createGenerator(image.getType());
        generator.setWidth(image.getWidth());
        generator.setHeight(image.getHeight());
        ImageCaptchaFactoryBuilder imageCaptchaFactoryBuilder = ImageCaptchaFactoryBuilder.getInstance(image);
        imageCaptchaFactoryBuilder.background().font().word().text().build(generator);
        generator.setFilterFactory(filterFactory);
        return new DefaultHandler(generator);
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletCaptchaConfiguration
    extends CaptchaConfiguration {
        @Bean
        public FilterRegistrationBean<CaptchaFilter> registerAuthFilter(Handler handler) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new CaptchaFilter(handler, this.captchaProperties.getSessionKey()));
            registration.addUrlPatterns(new String[]{this.captchaProperties.getVerifyCodePath()});
            registration.setName(CaptchaFilter.class.getName());
            registration.setOrder(1);
            return registration;
        }
    }
}

