/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.captcha.autoconfigure;

import com.buession.core.utils.RandomUtils;
import com.buession.security.captcha.color.ColorFactory;
import com.buession.security.captcha.color.RandomColorFactory;
import com.buession.security.captcha.color.SingleColorFactory;
import com.buession.springboot.captcha.autoconfigure.Image;
import java.awt.Color;

class ColorUtils {
    private ColorUtils() {
    }

    public static final ColorFactory createColorFactory(int min, int max) {
        if (min >= 0 && max <= 255 && max >= 0 && max <= 255) {
            return new RandomColorFactory(min, max);
        }
        int colorRgb = RandomUtils.nextInt((int)min, (int)max);
        return new SingleColorFactory(new Color(colorRgb));
    }

    public static final ColorFactory createColorFactory(Image.Color color) {
        return ColorUtils.createColorFactory(color.getMinColor(), color.getMaxColor());
    }
}

