/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.captcha.autoconfigure;

import com.buession.core.utils.RandomUtils;
import com.buession.core.validator.Validate;
import com.buession.security.captcha.background.BackgroundFactory;
import com.buession.security.captcha.background.SingleColorBackgroundFactory;
import com.buession.security.captcha.color.ColorFactory;
import com.buession.security.captcha.font.FontFactory;
import com.buession.security.captcha.font.RandomFontFactory;
import com.buession.security.captcha.font.SingleFontFactory;
import com.buession.security.captcha.handler.generator.Generator;
import com.buession.security.captcha.text.TextFactory;
import com.buession.security.captcha.word.RandomWordFactory;
import com.buession.security.captcha.word.WordFactory;
import com.buession.springboot.captcha.autoconfigure.ColorUtils;
import com.buession.springboot.captcha.autoconfigure.Image;
import java.awt.Color;

class ImageCaptchaFactoryBuilder {
    private Image config;
    private BackgroundFactory backgroundFactory;
    private FontFactory fontFactory;
    private ColorFactory colorFactory;
    private WordFactory wordFactory;
    private TextFactory textFactory;

    private ImageCaptchaFactoryBuilder(Image config) {
        this.config = config;
    }

    public static final ImageCaptchaFactoryBuilder getInstance(Image config) {
        return new ImageCaptchaFactoryBuilder(config);
    }

    public ImageCaptchaFactoryBuilder background() {
        Image.Background background = this.config.getBackground();
        this.backgroundFactory = new SingleColorBackgroundFactory(new Color(background.getColor().getR(), background.getColor().getG(), background.getColor().getB()), background.getAlpha());
        return this;
    }

    public ImageCaptchaFactoryBuilder font() {
        Image.Font font = this.config.getFont();
        if (Validate.isEmpty(font.getFamilies()) || font.getFamilies().size() == 1) {
            String fontName = SingleFontFactory.DEFAULT_FONT.getName();
            int fontSize = RandomUtils.nextInt((int)font.getMinSize(), (int)font.getMinSize());
            this.fontFactory = new SingleFontFactory(fontName, fontSize, font.getStyle());
        } else {
            this.fontFactory = new RandomFontFactory(font.getFamilies(), font.getMinSize(), font.getMaxSize(), font.getStyle());
        }
        Image.Color color = this.config.getFont().getColor();
        this.colorFactory = ColorUtils.createColorFactory(color.getMinColor(), color.getMaxColor());
        return this;
    }

    public ImageCaptchaFactoryBuilder word() {
        Image.Word word = this.config.getWord();
        if (Validate.hasText((CharSequence)word.getContent())) {
            this.wordFactory = new RandomWordFactory(word.getMinLength(), word.getMaxLength(), word.getContent());
        } else if (word.getWordType() != null) {
            this.wordFactory = new RandomWordFactory(word.getMinLength(), word.getMaxLength(), word.getWordType());
        }
        return this;
    }

    public ImageCaptchaFactoryBuilder text() throws IllegalAccessException, InstantiationException {
        Image.Text text = this.config.getText();
        this.textFactory = text.getTextFactoryClass().newInstance();
        this.textFactory.setTopMargin(text.getTopMargin());
        this.textFactory.setBottomMargin(text.getBottomMargin());
        this.textFactory.setLeftMargin(this.textFactory.getLeftMargin());
        this.textFactory.setRightMargin(this.textFactory.getRightMargin());
        return this;
    }

    public void build(Generator generator) {
        if (this.backgroundFactory != null) {
            generator.setBackgroundFactory(this.backgroundFactory);
        }
        if (this.wordFactory != null) {
            generator.setWordFactory(this.wordFactory);
        }
        if (this.textFactory != null) {
            if (this.fontFactory != null) {
                this.textFactory.setFontFactory(this.fontFactory);
            }
            if (this.colorFactory != null) {
                this.textFactory.setColorFactory(this.colorFactory);
            }
            generator.setTextFactory(this.textFactory);
        }
    }
}

