/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.datasource.autoconfigure;

import com.buession.springboot.datasource.autoconfigure.DataSourceConfiguration;
import com.buession.springboot.datasource.autoconfigure.DataSourceProperties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvidersConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@ConditionalOnMissingBean(type={"io.r2dbc.spi.ConnectionFactory"})
@EnableConfigurationProperties(value={DataSourceProperties.class})
@Import(value={DataSourcePoolMetadataProvidersConfiguration.class})
public class DataSourceAutoConfiguration {

    static class PooledDataSourceAvailableCondition
    extends SpringBootCondition {
        PooledDataSourceAvailableCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"PooledDataSource", (Object[])new Object[0]);
            if (DataSourceBuilder.findType((ClassLoader)context.getClassLoader()) != null) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"supported DataSource"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("supported DataSource").atAll());
        }
    }

    static class PooledDataSourceCondition
    extends AnyNestedCondition {
        PooledDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={PooledDataSourceAvailableCondition.class})
        static class PooledDataSourceAvailable {
            PooledDataSourceAvailable() {
            }
        }

        @ConditionalOnProperty(prefix="spring.datasource", name={"type"})
        static class ExplicitType {
            ExplicitType() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={PooledDataSourceCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class, XADataSource.class})
    @Import(value={DataSourceConfiguration.Hikari.class, DataSourceConfiguration.Tomcat.class, DataSourceConfiguration.Dbcp2.class, DataSourceConfiguration.Generic.class})
    static class PooledDataSourceConfiguration {
        PooledDataSourceConfiguration() {
        }
    }
}

