/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.datasource.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.buession.jdbc.datasource.DataSource;
import com.buession.jdbc.datasource.config.PoolConfiguration;
import com.buession.springboot.datasource.autoconfigure.DataSourceInitializer;
import com.buession.springboot.datasource.autoconfigure.DataSourceProperties;
import com.buession.springboot.datasource.autoconfigure.DataSources;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.datasource"})
public class DataSourceConfiguration {
    protected final DataSourceProperties properties;

    public DataSourceConfiguration(DataSourceProperties properties) {
        this.properties = properties;
    }

    protected static <T extends javax.sql.DataSource, P extends PoolConfiguration, D extends DataSource<T, P>> com.buession.springboot.datasource.core.DataSource createDataSource(Class<D> type, P poolConfiguration, DataSourceProperties dataSourceProperties) {
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer(type, poolConfiguration, dataSourceProperties);
        return dataSourceInitializer.createDataSource();
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={DataSourceProperties.class})
    @ConditionalOnMissingBean(value={com.buession.springboot.datasource.core.DataSource.class})
    @ConditionalOnProperty(prefix="spring.datasource", name={"type"})
    static class Generic
    extends DataSourceConfiguration {
        public Generic(DataSourceProperties properties) {
            super(properties);
        }

        @Bean
        public com.buession.springboot.datasource.core.DataSource dataSource() {
            return Generic.createDataSource(DataSources.GenericDataSource.class, this.properties.getGeneric(), this.properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={DataSourceProperties.class})
    @ConditionalOnClass(value={org.apache.tomcat.jdbc.pool.DataSource.class})
    @ConditionalOnMissingBean(value={com.buession.springboot.datasource.core.DataSource.class})
    @ConditionalOnProperty(prefix="spring.datasource", name={"type"}, havingValue="org.apache.tomcat.jdbc.pool.DataSource", matchIfMissing=true)
    static class Tomcat
    extends DataSourceConfiguration {
        public Tomcat(DataSourceProperties properties) {
            super(properties);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.tomcat")
        public com.buession.springboot.datasource.core.DataSource dataSource() {
            return Tomcat.createDataSource(DataSources.TomcatDataSource.class, this.properties.getTomcat(), this.properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={DataSourceProperties.class})
    @ConditionalOnClass(value={DruidDataSource.class})
    @ConditionalOnMissingBean(value={com.buession.springboot.datasource.core.DataSource.class})
    @ConditionalOnProperty(prefix="spring.datasource", name={"type"}, havingValue="com.alibaba.druid.pool.DruidDataSource", matchIfMissing=true)
    static class Druid
    extends DataSourceConfiguration {
        public Druid(DataSourceProperties properties) {
            super(properties);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.druid")
        public com.buession.springboot.datasource.core.DataSource dataSource() {
            return Druid.createDataSource(DataSources.DruidDataSource.class, this.properties.getDruid(), this.properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={DataSourceProperties.class})
    @ConditionalOnClass(value={BasicDataSource.class})
    @ConditionalOnMissingBean(value={com.buession.springboot.datasource.core.DataSource.class})
    @ConditionalOnProperty(prefix="spring.datasource", name={"type"}, havingValue="org.apache.commons.dbcp2.BasicDataSource", matchIfMissing=true)
    static class Dbcp2
    extends DataSourceConfiguration {
        public Dbcp2(DataSourceProperties properties) {
            super(properties);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.dbcp2")
        public com.buession.springboot.datasource.core.DataSource dataSource() {
            return Dbcp2.createDataSource(DataSources.Dbcp2DataSource.class, this.properties.getDbcp2(), this.properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={DataSourceProperties.class})
    @ConditionalOnClass(value={HikariDataSource.class})
    @ConditionalOnMissingBean(value={com.buession.springboot.datasource.core.DataSource.class})
    @ConditionalOnProperty(prefix="spring.datasource", name={"type"}, havingValue="com.zaxxer.hikari.HikariDataSource", matchIfMissing=true)
    static class Hikari
    extends DataSourceConfiguration {
        public Hikari(DataSourceProperties properties) {
            super(properties);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.hikari")
        public com.buession.springboot.datasource.core.DataSource dataSource() {
            return Hikari.createDataSource(DataSources.HikariDataSource.class, this.properties.getHikari(), this.properties);
        }
    }
}

