/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springboot.datasource.autoconfigure;

import com.buession.core.builder.ListBuilder;
import com.buession.core.validator.Validate;
import com.buession.jdbc.datasource.DataSource;
import com.buession.jdbc.datasource.config.PoolConfiguration;
import com.buession.springboot.datasource.autoconfigure.DataSourceProperties;
import java.lang.reflect.Constructor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;

class DataSourceInitializer<T extends javax.sql.DataSource, P extends PoolConfiguration, D extends DataSource<T, P>> {
    private final Class<D> type;
    private final P poolConfiguration;
    private final DataSourceProperties properties;
    private static final Logger logger = LoggerFactory.getLogger(DataSourceInitializer.class);

    DataSourceInitializer(Class<D> type, P poolConfiguration, DataSourceProperties properties) {
        this.type = type;
        this.poolConfiguration = poolConfiguration;
        this.properties = properties;
    }

    public com.buession.springboot.datasource.core.DataSource createDataSource() {
        com.buession.springboot.datasource.core.DataSource dataSource = new com.buession.springboot.datasource.core.DataSource();
        dataSource.setMaster((javax.sql.DataSource)this.createDataSource(this.properties.getMaster()));
        if (logger.isInfoEnabled()) {
            logger.info("Create master datasource: by driver {}, type {}", (Object)this.properties.getDriverClassName(), (Object)this.type.getName());
        }
        if (Validate.isEmpty(this.properties.getSlaves())) {
            dataSource.setSlaves(ListBuilder.of(this.createDataSource(this.properties.getMaster())));
        } else {
            dataSource.setSlaves(this.properties.getSlaves().parallelStream().map(this::createDataSource).collect(Collectors.toList()));
        }
        if (logger.isInfoEnabled()) {
            logger.info("Create {} size slave datasource: by driver {}, type {}", new Object[]{dataSource.getSlaves().size(), this.properties.getDriverClassName(), this.type.getName()});
        }
        return dataSource;
    }

    private T createDataSource(org.springframework.boot.autoconfigure.jdbc.DataSourceProperties properties) {
        try {
            Constructor<D> constructor = this.type.getConstructor(org.springframework.boot.autoconfigure.jdbc.DataSourceProperties.class);
            DataSource instance = (DataSource)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{properties});
            instance.setPoolConfiguration(this.poolConfiguration);
            return (T)instance.createDataSource();
        }
        catch (NoSuchMethodException e) {
            throw new BeanInstantiationException(this.type, "Can't specify more arguments than constructor parameters");
        }
    }
}

